/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.util.FileUtil;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.tasks.CreateTokenTask;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import de.undercouch.gradle.tasks.download.Download;
import groovy.lang.Closure;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.initialization.Settings;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.api.tasks.bundling.Tar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

public class RootProjectConfigurator
implements Plugin<Project> {
    public static final String BUNDLE_CONFIGURATION_NAME = "bundle";
    public static final String BUNDLE_GROUP = "bundle";
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String CREATE_TOKEN_TASK_NAME = "createToken";
    public static final String DIST_BUNDLE_TAR_TASK_NAME = "distBundleTar";
    public static final String DIST_BUNDLE_TASK_NAME = "distBundle";
    public static final String DIST_BUNDLE_ZIP_TASK_NAME = "distBundleZip";
    public static final String DOWNLOAD_BUNDLE_TASK_NAME = "downloadBundle";
    public static final String INIT_BUNDLE_TASK_NAME = "initBundle";
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private boolean _defaultRepositoryEnabled;

    @Deprecated
    public RootProjectConfigurator() {
    }

    public RootProjectConfigurator(Settings settings) {
        this._defaultRepositoryEnabled = GradleUtil.getProperty((Object)settings, "liferay.workspace..default.repository.enabled", true);
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        GradleUtil.applyPlugin((Project)project, LifecycleBasePlugin.class);
        if (this.isDefaultRepositoryEnabled()) {
            GradleUtil.addDefaultRepositories(project);
        }
        CreateTokenTask createTokenTask = this._addTaskCreateToken(project, workspaceExtension);
        Download downloadBundleTask = this._addTaskDownloadBundle(createTokenTask, workspaceExtension);
        Copy distBundleTask = this._addTaskDistBundle(project, downloadBundleTask, workspaceExtension);
        Tar distBundleTarTask = this._addTaskDistBundle(project, DIST_BUNDLE_TAR_TASK_NAME, Tar.class, distBundleTask, workspaceExtension);
        distBundleTarTask.setCompression(Compression.GZIP);
        distBundleTarTask.setExtension("tar.gz");
        this._addTaskDistBundle(project, DIST_BUNDLE_ZIP_TASK_NAME, Zip.class, distBundleTask, workspaceExtension);
        this._addTaskInitBundle(project, downloadBundleTask, workspaceExtension);
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    public void setDefaultRepositoryEnabled(boolean defaultRepositoryEnabled) {
        this._defaultRepositoryEnabled = defaultRepositoryEnabled;
    }

    private Copy _addTaskCopyBundle(Project project, String taskName, Download downloadBundleTask, final WorkspaceExtension workspaceExtension) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)taskName, Copy.class);
        this._configureTaskCopyBundleFromConfig(copy, new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(workspaceExtension.getConfigsDir(), workspaceExtension.getEnvironment());
            }
        });
        this._configureTaskCopyBundleFromConfig(copy, new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(workspaceExtension.getConfigsDir(), "common");
            }
        });
        this._configureTaskCopyBundleFromDownload(copy, downloadBundleTask);
        this._configureTaskCopyBundlePreserveTimestamps(copy);
        copy.dependsOn(new Object[]{downloadBundleTask});
        copy.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                Project project = copy.getProject();
                project.delete(new Object[]{copy.getDestinationDir()});
            }
        });
        copy.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        return copy;
    }

    private CreateTokenTask _addTaskCreateToken(Project project, final WorkspaceExtension workspaceExtension) {
        CreateTokenTask createTokenTask = (CreateTokenTask)GradleUtil.addTask((Project)project, (String)CREATE_TOKEN_TASK_NAME, CreateTokenTask.class);
        createTokenTask.setDescription("Creates a liferay.com download token.");
        createTokenTask.setEmailAddress(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return workspaceExtension.getBundleTokenEmailAddress();
            }
        });
        createTokenTask.setForce(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return workspaceExtension.isBundleTokenForce();
            }
        });
        createTokenTask.setGroup("bundle");
        createTokenTask.setPassword(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return workspaceExtension.getBundleTokenPassword();
            }
        });
        return createTokenTask;
    }

    private Copy _addTaskDistBundle(final Project project, Download downloadBundleTask, WorkspaceExtension workspaceExtension) {
        Copy copy = this._addTaskCopyBundle(project, DIST_BUNDLE_TASK_NAME, downloadBundleTask, workspaceExtension);
        this._configureTaskDisableUpToDate((Task)copy);
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), "dist");
            }
        });
        copy.setDescription("Assembles the Liferay bundle.");
        return copy;
    }

    private <T extends AbstractArchiveTask> T _addTaskDistBundle(Project project, String taskName, Class<T> clazz, final Copy distBundleTask, final WorkspaceExtension workspaceExtension) {
        AbstractArchiveTask task = (AbstractArchiveTask)GradleUtil.addTask((Project)project, (String)taskName, clazz);
        this._configureTaskDisableUpToDate((Task)task);
        task.into((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String bundleDistRootDirName = workspaceExtension.getBundleDistRootDirName();
                if (Validator.isNull((String)bundleDistRootDirName)) {
                    bundleDistRootDirName = "";
                }
                return bundleDistRootDirName;
            }
        }, (Closure)new Closure<Void>((Object)task){

            public void doCall(CopySpec copySpec) {
                copySpec.from(new Object[]{distBundleTask});
            }
        });
        task.setBaseName(project.getName());
        task.setDescription("Assembles the Liferay bundle and zips it up.");
        task.setDestinationDir(project.getBuildDir());
        task.setGroup("bundle");
        return (T)task;
    }

    private Download _addTaskDownloadBundle(final CreateTokenTask createTokenTask, final WorkspaceExtension workspaceExtension) {
        Project project = createTokenTask.getProject();
        final Download download = (Download)GradleUtil.addTask((Project)project, (String)DOWNLOAD_BUNDLE_TASK_NAME, Download.class);
        File destinationDir = new File(System.getProperty("user.home"), ".liferay/bundles");
        destinationDir.mkdirs();
        download.dest((Object)destinationDir);
        download.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                if (workspaceExtension.isBundleTokenDownload()) {
                    String token = FileUtil.read(createTokenTask.getTokenFile());
                    token = token.trim();
                    download.header("Authorization", "Bearer " + token);
                }
            }
        });
        download.onlyIfNewer(true);
        download.setDescription("Downloads the Liferay bundle zip file.");
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Object src;
                if (workspaceExtension.isBundleTokenDownload()) {
                    download.dependsOn(new Object[]{createTokenTask});
                }
                if ((src = download.getSrc()) != null) {
                    if (src instanceof List) {
                        List srcList = (List)src;
                        if (!srcList.isEmpty()) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                String bundleUrl = workspaceExtension.getBundleUrl();
                bundleUrl = bundleUrl.replace(" ", "%20");
                try {
                    download.src((Object)bundleUrl);
                }
                catch (MalformedURLException murle) {
                    throw new GradleException(murle.getMessage(), (Throwable)murle);
                }
            }
        });
        return download;
    }

    private Copy _addTaskInitBundle(Project project, Download downloadBundleTask, final WorkspaceExtension workspaceExtension) {
        Copy copy = this._addTaskCopyBundle(project, INIT_BUNDLE_TASK_NAME, downloadBundleTask, workspaceExtension);
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return workspaceExtension.getHomeDir();
            }
        });
        copy.setDescription("Downloads and unzips the bundle.");
        copy.setGroup("bundle");
        return copy;
    }

    private void _configureTaskCopyBundleFromConfig(Copy copy, Callable<File> dir) {
        copy.from(dir, (Closure)new Closure<Void>((Object)copy.getProject()){

            public void doCall(CopySpec copySpec) {
                copySpec.exclude(new String[]{"**/.touch"});
            }
        });
    }

    private void _configureTaskCopyBundleFromDownload(Copy copy, final Download download) {
        final Project project = copy.getProject();
        final HashSet rootDirNames = new HashSet();
        copy.dependsOn(new Object[]{download});
        copy.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                File destinationDir = copy.getDestinationDir();
                for (String rootDirName : rootDirNames) {
                    FileUtil.moveTree(new File(destinationDir, rootDirName), destinationDir);
                }
            }
        });
        copy.from((Object)new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                File dir = download.getDest();
                URL url = (URL)download.getSrc();
                String fileName = url.toString();
                fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                File file = new File(dir, fileName);
                if (fileName.endsWith(".tar.gz")) {
                    return project.tarTree((Object)file);
                }
                return project.zipTree((Object)file);
            }
        }, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.eachFile((Action)new Action<FileCopyDetails>(){

                    public void execute(FileCopyDetails fileCopyDetails) {
                        RelativePath relativePath = fileCopyDetails.getRelativePath();
                        String[] segments = relativePath.getSegments();
                        rootDirNames.add(segments[0]);
                    }
                });
                copySpec.eachFile((Action)new StripPathSegmentsAction(1));
            }
        });
    }

    private void _configureTaskCopyBundlePreserveTimestamps(Copy copy) {
        final HashSet fileCopyDetailsSet = new HashSet();
        copy.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                Logger logger = copy.getLogger();
                for (FileCopyDetails fileCopyDetails : fileCopyDetailsSet) {
                    File file = new File(copy.getDestinationDir(), fileCopyDetails.getPath());
                    if (!file.exists()) {
                        logger.error("Unable to set last modified time of {}, it has not been copied", (Object)file);
                        return;
                    }
                    boolean success = file.setLastModified(fileCopyDetails.getLastModified());
                    if (success) continue;
                    logger.error("Unable to set last modified time of {}", (Object)file);
                }
            }
        });
        copy.eachFile((Action)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetailsSet.add(fileCopyDetails);
            }
        });
    }

    private void _configureTaskDisableUpToDate(Task task) {
        TaskOutputs taskOutputs = task.getOutputs();
        taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
    }
}

