/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.ModulesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.PluginsProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.RootProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.ThemesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.WarsProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;

public class WorkspaceExtension {
    private static final String _BUNDLE_DIST_ROOT_DIR_NAME = null;
    private static final boolean _BUNDLE_TOKEN_DOWNLOAD = false;
    private static final String _BUNDLE_TOKEN_EMAIL_ADDRESS = null;
    private static final boolean _BUNDLE_TOKEN_FORCE = false;
    private static final String _BUNDLE_TOKEN_PASSWORD = null;
    private Object _bundleDistRootDirName;
    private Object _bundleTokenDownload;
    private Object _bundleTokenEmailAddress;
    private Object _bundleTokenForce;
    private Object _bundleTokenPassword;
    private Object _bundleUrl;
    private Object _configsDir;
    private Object _environment;
    private final Gradle _gradle;
    private Object _homeDir;
    private final Set<ProjectConfigurator> _projectConfigurators = new HashSet<ProjectConfigurator>();
    private final Plugin<Project> _rootProjectConfigurator;

    public WorkspaceExtension(Settings settings) {
        this._gradle = settings.getGradle();
        this._projectConfigurators.add(new ModulesProjectConfigurator(settings));
        this._projectConfigurators.add(new PluginsProjectConfigurator(settings));
        this._projectConfigurators.add(new ThemesProjectConfigurator(settings));
        this._projectConfigurators.add(new WarsProjectConfigurator(settings));
        this._bundleDistRootDirName = this._getProperty((Object)settings, "bundle.dist.root.dir", _BUNDLE_DIST_ROOT_DIR_NAME);
        this._bundleTokenDownload = this._getProperty((Object)settings, "bundle.token.download", false);
        this._bundleTokenEmailAddress = this._getProperty((Object)settings, "bundle.token.email.address", _BUNDLE_TOKEN_EMAIL_ADDRESS);
        this._bundleTokenForce = this._getProperty((Object)settings, "bundle.token.force", false);
        this._bundleTokenPassword = this._getProperty((Object)settings, "bundle.token.password", _BUNDLE_TOKEN_PASSWORD);
        this._bundleUrl = this._getProperty((Object)settings, "bundle.url", "https://cdn.lfrs.sl/releases.liferay.com/portal/7.0.3-ga4/liferay-ce-portal-tomcat-7.0-ga4-20170613175008905.zip");
        this._configsDir = this._getProperty((Object)settings, "configs.dir", "configs");
        this._environment = this._getProperty((Object)settings, "environment", "local");
        this._homeDir = this._getProperty((Object)settings, "home.dir", "bundles");
        this._rootProjectConfigurator = new RootProjectConfigurator(settings);
    }

    public String getBundleDistRootDirName() {
        return GradleUtil.toString((Object)this._bundleDistRootDirName);
    }

    public String getBundleTokenEmailAddress() {
        return GradleUtil.toString((Object)this._bundleTokenEmailAddress);
    }

    public String getBundleTokenPassword() {
        return GradleUtil.toString((Object)this._bundleTokenPassword);
    }

    public String getBundleUrl() {
        return GradleUtil.toString((Object)this._bundleUrl);
    }

    public File getConfigsDir() {
        return GradleUtil.toFile((Project)this._gradle.getRootProject(), (Object)this._configsDir);
    }

    public String getEnvironment() {
        return GradleUtil.toString((Object)this._environment);
    }

    public File getHomeDir() {
        return GradleUtil.toFile((Project)this._gradle.getRootProject(), (Object)this._homeDir);
    }

    public Iterable<ProjectConfigurator> getProjectConfigurators() {
        return Collections.unmodifiableSet(this._projectConfigurators);
    }

    public Plugin<Project> getRootProjectConfigurator() {
        return this._rootProjectConfigurator;
    }

    public boolean isBundleTokenDownload() {
        return GradleUtil.toBoolean(this._bundleTokenDownload);
    }

    public boolean isBundleTokenForce() {
        return GradleUtil.toBoolean(this._bundleTokenForce);
    }

    public ProjectConfigurator propertyMissing(String name) {
        for (ProjectConfigurator projectConfigurator : this._projectConfigurators) {
            if (!name.equals(projectConfigurator.getName())) continue;
            return projectConfigurator;
        }
        throw new MissingPropertyException(name, ProjectConfigurator.class);
    }

    public void setBundleDistRootDirName(Object bundleDistRootDirName) {
        this._bundleDistRootDirName = bundleDistRootDirName;
    }

    public void setBundleTokenDownload(Object bundleTokenDownload) {
        this._bundleTokenDownload = bundleTokenDownload;
    }

    public void setBundleTokenEmailAddress(Object bundleTokenEmailAddress) {
        this._bundleTokenEmailAddress = bundleTokenEmailAddress;
    }

    public void setBundleTokenForce(Object bundleTokenForce) {
        this._bundleTokenForce = bundleTokenForce;
    }

    public void setBundleTokenPassword(Object bundleTokenPassword) {
        this._bundleTokenPassword = bundleTokenPassword;
    }

    public void setBundleUrl(Object bundleUrl) {
        this._bundleUrl = bundleUrl;
    }

    public void setConfigsDir(Object configsDir) {
        this._configsDir = configsDir;
    }

    public void setEnvironment(Object environment) {
        this._environment = environment;
    }

    public void setHomeDir(Object homeDir) {
        this._homeDir = homeDir;
    }

    private boolean _getProperty(Object object, String keySuffix, boolean defaultValue) {
        return GradleUtil.getProperty(object, "liferay.workspace." + keySuffix, defaultValue);
    }

    private String _getProperty(Object object, String keySuffix, String defaultValue) {
        return GradleUtil.getProperty(object, "liferay.workspace." + keySuffix, defaultValue);
    }
}

