/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.ModulesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.PluginsProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.RootProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.ThemesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.WarsProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;

public class WorkspaceExtension {
    private static final String _BUNDLE_DIST_ROOT_DIR_NAME = null;
    private static final String _BUNDLE_URL = "https://cdn.lfrs.sl/releases.liferay.com/portal/7.0.2-ga3/liferay-ce-portal-tomcat-7.0-ga3-20160804222206210.zip";
    private static final String _CONFIGS_DIR = "configs";
    private static final String _ENVIRONMENT = "local";
    private static final String _HOME_DIR = "bundles";
    private Object _bundleDistRootDirName;
    private Object _bundleUrl;
    private Object _configsDir;
    private Object _environment;
    private final Gradle _gradle;
    private Object _homeDir;
    private final Set<ProjectConfigurator> _projectConfigurators = new HashSet<ProjectConfigurator>();
    private final Plugin<Project> _rootProjectConfigurator;

    public WorkspaceExtension(Settings settings) {
        this._gradle = settings.getGradle();
        this._projectConfigurators.add(new ModulesProjectConfigurator(settings));
        this._projectConfigurators.add(new PluginsProjectConfigurator(settings));
        this._projectConfigurators.add(new ThemesProjectConfigurator(settings));
        this._projectConfigurators.add(new WarsProjectConfigurator(settings));
        this._bundleDistRootDirName = this._getProperty(settings, "bundle.dist.root.dir", _BUNDLE_DIST_ROOT_DIR_NAME);
        this._bundleUrl = this._getProperty(settings, "bundle.url", _BUNDLE_URL);
        this._configsDir = this._getProperty(settings, "configs.dir", _CONFIGS_DIR);
        this._environment = this._getProperty(settings, "environment", _ENVIRONMENT);
        this._homeDir = this._getProperty(settings, "home.dir", _HOME_DIR);
        this._rootProjectConfigurator = new RootProjectConfigurator(settings);
    }

    public String getBundleDistRootDirName() {
        return GradleUtil.toString((Object)this._bundleDistRootDirName);
    }

    public String getBundleUrl() {
        return GradleUtil.toString((Object)this._bundleUrl);
    }

    public File getConfigsDir() {
        return GradleUtil.toFile((Project)this._gradle.getRootProject(), (Object)this._configsDir);
    }

    public String getEnvironment() {
        return GradleUtil.toString((Object)this._environment);
    }

    public File getHomeDir() {
        return GradleUtil.toFile((Project)this._gradle.getRootProject(), (Object)this._homeDir);
    }

    public Iterable<ProjectConfigurator> getProjectConfigurators() {
        return Collections.unmodifiableSet(this._projectConfigurators);
    }

    public Plugin<Project> getRootProjectConfigurator() {
        return this._rootProjectConfigurator;
    }

    public ProjectConfigurator propertyMissing(String name) {
        for (ProjectConfigurator projectConfigurator : this._projectConfigurators) {
            if (!name.equals(projectConfigurator.getName())) continue;
            return projectConfigurator;
        }
        throw new MissingPropertyException(name, ProjectConfigurator.class);
    }

    public void setBundleDistRootDirName(Object bundleDistRootDirName) {
        this._bundleDistRootDirName = bundleDistRootDirName;
    }

    public void setBundleUrl(Object bundleUrl) {
        this._bundleUrl = bundleUrl;
    }

    public void setConfigsDir(Object configsDir) {
        this._configsDir = configsDir;
    }

    public void setEnvironment(Object environment) {
        this._environment = environment;
    }

    public void setHomeDir(Object homeDir) {
        this._homeDir = homeDir;
    }

    private String _getProperty(Object object, String keySuffix, String defaultValue) {
        return GradleUtil.getProperty(object, "liferay.workspace." + keySuffix, defaultValue);
    }
}

