/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.initialization.Settings;

public abstract class BaseProjectConfigurator
implements ProjectConfigurator {
    private final Set<File> _defaultRootDirs;

    public BaseProjectConfigurator(Settings settings) {
        String defaultRootDirNames = GradleUtil.getProperty((Object)settings, this.getDefaultRootDirPropertyName(), null);
        if (Validator.isNotNull((String)defaultRootDirNames)) {
            this._defaultRootDirs = new HashSet<File>();
            for (String dirName : defaultRootDirNames.split("\\s*,\\s*")) {
                File dir = new File(settings.getRootDir(), dirName);
                this._defaultRootDirs.add(dir);
            }
        } else {
            File dir = new File(settings.getRootDir(), this.getDefaultRootDirName());
            this._defaultRootDirs = Collections.singleton(dir);
        }
    }

    @Override
    public Iterable<File> getDefaultRootDirs() {
        return this._defaultRootDirs;
    }

    @Override
    public Iterable<File> getProjectDirs(File rootDir) {
        try {
            if (!rootDir.exists()) {
                return Collections.emptySet();
            }
            return this.doGetProjectDirs(rootDir);
        }
        catch (Exception e) {
            throw new GradleException("Unable to get project directories from " + rootDir, (Throwable)e);
        }
    }

    protected abstract Iterable<File> doGetProjectDirs(File var1) throws Exception;

    protected String getDefaultRootDirName() {
        return this.getName();
    }

    protected String getDefaultRootDirPropertyName() {
        return "liferay.workspace." + this.getName() + ".dir";
    }
}

