/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.tasks;

import com.liferay.gradle.plugins.workspace.internal.util.FileUtil;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class UpdatePropertiesTask
extends DefaultTask {
    private final Map<String, Object> _properties = new HashMap<String, Object>();
    private Object _propertiesFile;

    @Input
    public Map<String, Object> getProperties() {
        return this._properties;
    }

    @Input
    public File getPropertiesFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._propertiesFile);
    }

    public UpdatePropertiesTask properties(Map<String, Object> properties) {
        this._properties.putAll(properties);
        return this;
    }

    public UpdatePropertiesTask property(String key, Object value) {
        return this.properties(Collections.singletonMap(key, value));
    }

    public void setProperties(Map<String, Object> properties) {
        this._properties.clear();
        this.properties(properties);
    }

    public void setPropertiesFile(Object propertiesFile) {
        this._propertiesFile = propertiesFile;
    }

    @TaskAction
    public void updateProperties() throws IOException {
        File propertiesFile = this.getPropertiesFile();
        Properties properties = FileUtil.readProperties((File)propertiesFile);
        for (Map.Entry<String, Object> entry : this._properties.entrySet()) {
            String key = entry.getKey();
            String value = GradleUtil.toString((Object)entry.getValue());
            properties.setProperty(key, value);
        }
        try (OutputStream outputStream = Files.newOutputStream(propertiesFile.toPath(), new OpenOption[0]);){
            properties.store(outputStream, null);
        }
    }
}

