/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.configurators;

import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.configurators.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.FileUtil;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.tasks.UpdatePropertiesTask;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.AntBuilder;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;

public class PluginsProjectConfigurator
extends BaseProjectConfigurator {
    public static final String UPDATE_PROPERTIES_TASK_NAME = "updateProperties";
    private static final String _DEFAULT_ROOT_DIR_NAME = "plugins-sdk";
    private static final String _DEFAULT_ROOT_DIR_PROPERTY_NAME = "liferay.workspace.plugins.sdk.dir";
    private static final String _NAME = "plugins";

    public PluginsProjectConfigurator(Settings settings) {
        super(settings);
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        Task initBundleTask = GradleUtil.getTask((Project)project.getRootProject(), (String)"initBundle");
        this._configureAnt(project);
        UpdatePropertiesTask updatePropertiesTask = this._addTaskUpdateProperties(project, workspaceExtension);
        this._addTaskBuild(project, updatePropertiesTask);
        Task warTask = GradleUtil.getTask((Project)project, (String)"war");
        this._configureTaskWar(warTask, workspaceExtension, initBundleTask);
        this._configureRootTaskDistBundle(warTask);
    }

    @Override
    public String getName() {
        return _NAME;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        File buildXmlFile = new File(rootDir, "build.xml");
        if (!buildXmlFile.exists()) {
            return Collections.emptySet();
        }
        return Collections.singleton(rootDir);
    }

    @Override
    protected String getDefaultRootDirName() {
        return _DEFAULT_ROOT_DIR_NAME;
    }

    @Override
    protected String getDefaultRootDirPropertyName() {
        return _DEFAULT_ROOT_DIR_PROPERTY_NAME;
    }

    private Task _addTaskBuild(Project project, UpdatePropertiesTask updatePropertiesTask) {
        Task task = project.task("build");
        task.dependsOn(new Object[]{updatePropertiesTask, "war"});
        task.setDescription("Alias for 'ant war'.");
        return task;
    }

    private UpdatePropertiesTask _addTaskUpdateProperties(Project project, final WorkspaceExtension workspaceExtension) {
        UpdatePropertiesTask updatePropertiesTask = (UpdatePropertiesTask)GradleUtil.addTask((Project)project, (String)UPDATE_PROPERTIES_TASK_NAME, UpdatePropertiesTask.class);
        updatePropertiesTask.property("app.server.parent.dir", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return FileUtil.getAbsolutePath((File)workspaceExtension.getHomeDir());
            }
        });
        updatePropertiesTask.setDescription("Updates the Plugins SDK build properties with the workspace configuration.");
        String userName = System.getProperty("user.name");
        updatePropertiesTask.setPropertiesFile("build." + userName + ".properties");
        return updatePropertiesTask;
    }

    private void _configureAnt(Project project) {
        AntBuilder antBuilder = project.getAnt();
        antBuilder.importBuild((Object)"build.xml");
    }

    private void _configureRootTaskDistBundle(final Task warTask) {
        Project project = warTask.getProject();
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.dependsOn(new Object[]{warTask});
        copy.into((Object)"osgi/modules", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                Project project = warTask.getProject();
                ConfigurableFileTree configurableFileTree = project.fileTree((Object)"dist");
                configurableFileTree.builtBy(new Object[]{warTask});
                configurableFileTree.include(new String[]{"*.war"});
                copySpec.from(new Object[]{configurableFileTree});
            }
        });
    }

    private void _configureTaskWar(Task warTask, final WorkspaceExtension workspaceExtension, final Task initBundleTask) {
        warTask.dependsOn(new Object[]{new Callable<Task>(){

            @Override
            public Task call() throws Exception {
                File homeDir = workspaceExtension.getHomeDir();
                if (homeDir.exists()) {
                    return null;
                }
                return initBundleTask;
            }
        }});
    }
}

