/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.configurators;

import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.configurators.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.bundling.War;

public class WarsProjectConfigurator
extends BaseProjectConfigurator {
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private static final String _DEFAULT_REPOSITORY_URL = "https://cdn.lfrs.sl/repository.liferay.com/nexus/content/groups/public";
    private static final String _NAME = "wars";
    private boolean _defaultRepositoryEnabled;

    public WarsProjectConfigurator(Settings settings) {
        super(settings);
        this._defaultRepositoryEnabled = GradleUtil.getProperty((Object)settings, "liferay.workspace.wars.default.repository.enabled", true);
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        GradleUtil.applyPlugin((Project)project, WarPlugin.class);
        War war = (War)GradleUtil.getTask((Project)project, (String)"war");
        this._addRepositoryDefault(project);
        this._addTaskDeploy(war, workspaceExtension);
        this._configureRootTaskDistBundle(war);
    }

    @Override
    public String getName() {
        return _NAME;
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    public void setDefaultRepositoryEnabled(boolean defaultRepositoryEnabled) {
        this._defaultRepositoryEnabled = defaultRepositoryEnabled;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                if (Files.isDirectory(dirPath.resolve("src"), new LinkOption[0])) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    private MavenArtifactRepository _addRepositoryDefault(Project project) {
        if (!this.isDefaultRepositoryEnabled()) {
            return null;
        }
        RepositoryHandler repositoryHandler = project.getRepositories();
        return repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository mavenArtifactRepository) {
                mavenArtifactRepository.setUrl((Object)WarsProjectConfigurator._DEFAULT_REPOSITORY_URL);
            }
        });
    }

    private Copy _addTaskDeploy(War war, final WorkspaceExtension workspaceExtension) {
        Copy copy = (Copy)GradleUtil.addTask((Project)war.getProject(), (String)"deploy", Copy.class);
        copy.from(new Object[]{war});
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(workspaceExtension.getHomeDir(), "deploy");
            }
        });
        copy.setDescription("Assembles the project and deploys it to Liferay.");
        copy.setGroup("build");
        return copy;
    }

    private void _configureRootTaskDistBundle(final War war) {
        Project project = war.getProject();
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.into((Object)"osgi/war", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.from(new Object[]{war});
            }
        });
    }
}

