/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;

public class WorkspacePlugin
implements Plugin<Settings> {
    public static final String EXTENSION_NAME = "liferayWorkspace";
    public static final String PROPERTY_PREFIX = "liferay.workspace.";
    private static final Map<String, ProjectConfigurator> _projectConfiguratorsMap = new HashMap<String, ProjectConfigurator>();

    public void apply(Settings settings) {
        Gradle gradle = settings.getGradle();
        final WorkspaceExtension workspaceExtension = this._addWorkspaceExtension(settings);
        for (ProjectConfigurator projectConfigurator : workspaceExtension.getProjectConfigurators()) {
            for (File rootDir : projectConfigurator.getDefaultRootDirs()) {
                for (File projectDir : projectConfigurator.getProjectDirs(rootDir)) {
                    String projectPath = GradleUtil.getProjectPath(projectDir, settings.getRootDir());
                    settings.include(new String[]{projectPath});
                    _projectConfiguratorsMap.put(projectPath, projectConfigurator);
                }
            }
        }
        gradle.beforeProject((Closure)new Closure<Void>((Object)settings){

            public void doCall(Project project) {
                WorkspacePlugin.this._setPortalVersion(project, workspaceExtension);
                Plugin<Project> plugin = null;
                if (project.getParent() == null) {
                    for (ProjectConfigurator projectConfigurator : workspaceExtension.getProjectConfigurators()) {
                        projectConfigurator.configureRootProject(project, workspaceExtension);
                    }
                    plugin = workspaceExtension.getRootProjectConfigurator();
                } else {
                    plugin = (Plugin<Project>)_projectConfiguratorsMap.get(project.getPath());
                }
                if (plugin != null) {
                    plugin.apply((Object)project);
                }
            }
        });
    }

    private WorkspaceExtension _addWorkspaceExtension(Settings settings) {
        ExtensionAware extensionAware = (ExtensionAware)settings.getGradle();
        ExtensionContainer extensionContainer = extensionAware.getExtensions();
        return (WorkspaceExtension)extensionContainer.create(EXTENSION_NAME, WorkspaceExtension.class, new Object[]{settings});
    }

    private void _setPortalVersion(Project project, WorkspaceExtension workspaceExtension) {
        String portalVersion = GradleUtil.getProperty((ExtensionAware)project, (String)"portal.version", (String)null);
        if (Validator.isNotNull((String)portalVersion)) {
            return;
        }
        String bundleUrl = workspaceExtension.getBundleUrl();
        if (bundleUrl.contains("7.0.")) {
            GradleUtil.setProperty((ExtensionAware)project, (String)"portal.version", (Object)"7.0.x");
        }
    }
}

