/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.configurators;

import com.liferay.gradle.plugins.LiferayOSGiPlugin;
import com.liferay.gradle.plugins.target.platform.TargetPlatformIDEPlugin;
import com.liferay.gradle.plugins.target.platform.extensions.TargetPlatformExtension;
import com.liferay.gradle.plugins.target.platform.extensions.TargetPlatformIDEExtension;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;

public class TargetPlatformRootProjectConfigurator
implements Plugin<Project> {
    public static final Plugin<Project> INSTANCE = new TargetPlatformRootProjectConfigurator();
    private static final String _ARTIFACT_ID_RELEASE_DXP_BOM = "release.dxp.bom";
    private static final String _ARTIFACT_ID_RELEASE_DXP_BOM_COMPILE_ONLY = "release.dxp.bom.compile.only";
    private static final String _ARTIFACT_ID_RELEASE_DXP_DISTRO = "release.dxp.distro";
    private static final String _ARTIFACT_ID_RELEASE_PORTAL_BOM = "release.portal.bom";
    private static final String _ARTIFACT_ID_RELEASE_PORTAL_BOM_COMPILE_ONLY = "release.portal.bom.compile.only";
    private static final String _ARTIFACT_ID_RELEASE_PORTAL_DISTRO = "release.portal.distro";
    private static final String _GROUP_ID_LIFERAY_PORTAL = "com.liferay.portal";
    private static final Pattern _dxpVersionPattern = Pattern.compile("7\\.[0-2]\\.1[0-9](\\.[0-9]+)?");
    private final Pattern _externalVersionPattern = Pattern.compile("([0-9]+)\\.([0-9]+)-([A-Za-z]+)([0-9]+)");

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        String targetPlatformVersion = workspaceExtension.getTargetPlatformVersion();
        if (Validator.isNull((String)targetPlatformVersion)) {
            return;
        }
        Matcher matcher = this._externalVersionPattern.matcher(targetPlatformVersion);
        String normalizedTargetPlatformVersion = null;
        if (matcher.matches()) {
            StringBuilder sb = new StringBuilder();
            sb.append(matcher.group(1));
            sb.append('.');
            sb.append(matcher.group(2));
            sb.append('.');
            String label = matcher.group(3);
            try {
                int labelNumber = Integer.parseInt(matcher.group(4));
                if (label.startsWith("GA")) {
                    sb.append(labelNumber - 1);
                } else if (label.startsWith("sp")) {
                    sb.append(labelNumber);
                }
            }
            catch (NumberFormatException nfe) {
                throw new GradleException("Invalid version property value", (Throwable)nfe);
            }
            normalizedTargetPlatformVersion = sb.toString();
        } else {
            normalizedTargetPlatformVersion = targetPlatformVersion;
        }
        GradleUtil.applyPlugin((Project)project, TargetPlatformIDEPlugin.class);
        this._configureConfigurationBundles(project);
        this._configureTargetPlatform(project);
        this._configureTargetPlatformIDE(project);
        this._addDependenciesTargetPlatformBoms(project, normalizedTargetPlatformVersion);
        this._addDependenciesTargetPlatformDistro(project, normalizedTargetPlatformVersion);
    }

    private TargetPlatformRootProjectConfigurator() {
    }

    private void _addDependenciesTargetPlatformBoms(Project project, String targetPlatformVersion) {
        Matcher matcher = _dxpVersionPattern.matcher(targetPlatformVersion);
        String bomArtifactId = null;
        String bomCompileOnlyArtifactId = null;
        if (matcher.matches()) {
            bomArtifactId = _ARTIFACT_ID_RELEASE_DXP_BOM;
            bomCompileOnlyArtifactId = _ARTIFACT_ID_RELEASE_DXP_BOM_COMPILE_ONLY;
        } else {
            bomArtifactId = _ARTIFACT_ID_RELEASE_PORTAL_BOM;
            bomCompileOnlyArtifactId = _ARTIFACT_ID_RELEASE_PORTAL_BOM_COMPILE_ONLY;
        }
        GradleUtil.addDependency((Project)project, (String)"targetPlatformBoms", (String)_GROUP_ID_LIFERAY_PORTAL, (String)bomArtifactId, (String)targetPlatformVersion);
        GradleUtil.addDependency((Project)project, (String)"targetPlatformBoms", (String)_GROUP_ID_LIFERAY_PORTAL, (String)bomCompileOnlyArtifactId, (String)targetPlatformVersion);
    }

    private void _addDependenciesTargetPlatformDistro(final Project project, final String targetPlatformVersion) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"targetPlatformDistro");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                Matcher matcher = _dxpVersionPattern.matcher(targetPlatformVersion);
                String artifactId = TargetPlatformRootProjectConfigurator._ARTIFACT_ID_RELEASE_PORTAL_DISTRO;
                if (matcher.matches()) {
                    artifactId = TargetPlatformRootProjectConfigurator._ARTIFACT_ID_RELEASE_DXP_DISTRO;
                }
                GradleUtil.addDependency((Project)project, (String)"targetPlatformDistro", (String)TargetPlatformRootProjectConfigurator._GROUP_ID_LIFERAY_PORTAL, (String)artifactId, (String)targetPlatformVersion);
            }
        });
    }

    private void _configureConfigurationBundles(Project project) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"targetPlatformBundles");
        Configuration providedModulesConfiguration = GradleUtil.getConfiguration((Project)project, (String)"providedModules");
        configuration.extendsFrom(new Configuration[]{providedModulesConfiguration});
    }

    private void _configureTargetPlatform(Project project) {
        TargetPlatformExtension targetPlatformExtension = (TargetPlatformExtension)GradleUtil.getExtension((ExtensionAware)project, TargetPlatformExtension.class);
        targetPlatformExtension.resolveOnlyIf((Spec)new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                String projectName = project.getName();
                return !projectName.endsWith("-test");
            }
        });
        targetPlatformExtension.resolveOnlyIf((Spec)new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                PluginContainer pluginContainer = project.getPlugins();
                return pluginContainer.hasPlugin(LiferayOSGiPlugin.class);
            }
        });
    }

    private void _configureTargetPlatformIDE(Project project) {
        TargetPlatformIDEExtension targetPlatformIDEExtension = (TargetPlatformIDEExtension)GradleUtil.getExtension((ExtensionAware)project, TargetPlatformIDEExtension.class);
        targetPlatformIDEExtension.includeGroups(new Object[]{"com.liferay", _GROUP_ID_LIFERAY_PORTAL});
    }
}

