/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.workspace.tasks;

import com.liferay.gradle.plugins.workspace.internal.util.FileUtil;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

import java.nio.file.Files;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

/**
 * @author Andrea Di Giorgi
 */
public class UpdatePropertiesTask extends DefaultTask {

	@Input
	public Map<String, Object> getProperties() {
		return _properties;
	}

	@Input
	public File getPropertiesFile() {
		return GradleUtil.toFile(getProject(), _propertiesFile);
	}

	public UpdatePropertiesTask properties(Map<String, Object> properties) {
		_properties.putAll(properties);

		return this;
	}

	public UpdatePropertiesTask property(String key, Object value) {
		return properties(Collections.singletonMap(key, value));
	}

	public void setProperties(Map<String, Object> properties) {
		_properties.clear();

		properties(properties);
	}

	public void setPropertiesFile(Object propertiesFile) {
		_propertiesFile = propertiesFile;
	}

	@TaskAction
	public void updateProperties() throws IOException {
		File propertiesFile = getPropertiesFile();

		Properties properties = FileUtil.readProperties(propertiesFile);

		for (Map.Entry<String, Object> entry : _properties.entrySet()) {
			String key = entry.getKey();
			String value = GradleUtil.toString(entry.getValue());

			properties.setProperty(key, value);
		}

		try (OutputStream outputStream = Files.newOutputStream(
				propertiesFile.toPath())) {

			properties.store(outputStream, null);
		}
	}

	private final Map<String, Object> _properties = new HashMap<>();
	private Object _propertiesFile;

}