/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.ExtProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.ModulesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.PluginsProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.RootProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.ThemesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.WarsProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;

public class WorkspaceExtension {
    private static final File _BUNDLE_CACHE_DIR = new File(System.getProperty("user.home"), ".liferay/bundles");
    private static final String _BUNDLE_DIST_ROOT_DIR_NAME = null;
    private static final boolean _BUNDLE_TOKEN_DOWNLOAD = false;
    private static final String _BUNDLE_TOKEN_EMAIL_ADDRESS = null;
    private static final boolean _BUNDLE_TOKEN_FORCE = false;
    private static final String _BUNDLE_TOKEN_PASSWORD = null;
    private static final String _BUNDLE_TOKEN_PASSWORD_FILE = null;
    private static final File _DOCKER_DIR = new File("build" + File.separator + "docker");
    private static final String _DOCKER_IMAGE_LIFERAY = "liferay/portal:7.1.1-ga2";
    private Object _bundleCacheDir;
    private Object _bundleDistRootDirName;
    private Object _bundleTokenDownload;
    private Object _bundleTokenEmailAddress;
    private Object _bundleTokenForce;
    private Object _bundleTokenPassword;
    private Object _bundleTokenPasswordFile;
    private Object _bundleUrl;
    private Object _configsDir;
    private Object _dockerDir;
    private Object _dockerImageLiferay;
    private Object _environment;
    private final Gradle _gradle;
    private Object _homeDir;
    private final Set<ProjectConfigurator> _projectConfigurators = new HashSet<ProjectConfigurator>();
    private final Plugin<Project> _rootProjectConfigurator;
    private Object _targetPlatformVersion;

    public WorkspaceExtension(Settings settings) {
        this._gradle = settings.getGradle();
        this._projectConfigurators.add(new ExtProjectConfigurator(settings));
        this._projectConfigurators.add(new ModulesProjectConfigurator(settings));
        this._projectConfigurators.add(new PluginsProjectConfigurator(settings));
        this._projectConfigurators.add(new ThemesProjectConfigurator(settings));
        this._projectConfigurators.add(new WarsProjectConfigurator(settings));
        this._bundleCacheDir = this._getProperty((Object)settings, "bundle.cache.dir", _BUNDLE_CACHE_DIR);
        this._bundleDistRootDirName = this._getProperty((Object)settings, "bundle.dist.root.dir", _BUNDLE_DIST_ROOT_DIR_NAME);
        this._bundleTokenDownload = this._getProperty((Object)settings, "bundle.token.download", false);
        this._bundleTokenEmailAddress = this._getProperty((Object)settings, "bundle.token.email.address", _BUNDLE_TOKEN_EMAIL_ADDRESS);
        this._bundleTokenForce = this._getProperty((Object)settings, "bundle.token.force", false);
        this._bundleTokenPassword = this._getProperty((Object)settings, "bundle.token.password", _BUNDLE_TOKEN_PASSWORD);
        this._bundleTokenPasswordFile = this._getProperty((Object)settings, "bundle.token.password.file", _BUNDLE_TOKEN_PASSWORD_FILE);
        this._bundleUrl = this._getProperty((Object)settings, "bundle.url", "https://releases-cdn.liferay.com/portal/7.1.2-ga3/liferay-ce-portal-tomcat-7.1.2-ga3-20190107144105508.tar.gz");
        this._configsDir = this._getProperty((Object)settings, "configs.dir", "configs");
        this._dockerImageLiferay = this._getProperty((Object)settings, "docker.image.liferay", _DOCKER_IMAGE_LIFERAY);
        this._dockerDir = this._getProperty((Object)settings, "docker.dir", _DOCKER_DIR);
        this._environment = this._getProperty((Object)settings, "environment", "local");
        this._homeDir = this._getProperty((Object)settings, "home.dir", "bundles");
        this._targetPlatformVersion = this._getProperty((Object)settings, "target.platform.version", (String)null);
        this._rootProjectConfigurator = new RootProjectConfigurator(settings);
    }

    public File getBundleCacheDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._bundleCacheDir);
    }

    public String getBundleDistRootDirName() {
        return GradleUtil.toString((Object)this._bundleDistRootDirName);
    }

    public String getBundleTokenEmailAddress() {
        return GradleUtil.toString((Object)this._bundleTokenEmailAddress);
    }

    public String getBundleTokenPassword() {
        return GradleUtil.toString((Object)this._bundleTokenPassword);
    }

    public File getBundleTokenPasswordFile() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._bundleTokenPasswordFile);
    }

    public String getBundleUrl() {
        return GradleUtil.toString((Object)this._bundleUrl);
    }

    public File getConfigsDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._configsDir);
    }

    public File getDockerDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._dockerDir);
    }

    public String getDockerImageLiferay() {
        return GradleUtil.toString((Object)this._dockerImageLiferay);
    }

    public String getEnvironment() {
        return GradleUtil.toString((Object)this._environment);
    }

    public File getHomeDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._homeDir);
    }

    public Iterable<ProjectConfigurator> getProjectConfigurators() {
        return Collections.unmodifiableSet(this._projectConfigurators);
    }

    public Plugin<Project> getRootProjectConfigurator() {
        return this._rootProjectConfigurator;
    }

    public String getTargetPlatformVersion() {
        return GradleUtil.toString((Object)this._targetPlatformVersion);
    }

    public boolean isBundleTokenDownload() {
        return GradleUtil.toBoolean(this._bundleTokenDownload);
    }

    public boolean isBundleTokenForce() {
        return GradleUtil.toBoolean(this._bundleTokenForce);
    }

    public ProjectConfigurator propertyMissing(String name) {
        for (ProjectConfigurator projectConfigurator : this._projectConfigurators) {
            if (!name.equals(projectConfigurator.getName())) continue;
            return projectConfigurator;
        }
        throw new MissingPropertyException(name, ProjectConfigurator.class);
    }

    public void setBundleCacheDir(Object bundleCacheDir) {
        this._bundleCacheDir = bundleCacheDir;
    }

    public void setBundleDistRootDirName(Object bundleDistRootDirName) {
        this._bundleDistRootDirName = bundleDistRootDirName;
    }

    public void setBundleTokenDownload(Object bundleTokenDownload) {
        this._bundleTokenDownload = bundleTokenDownload;
    }

    public void setBundleTokenEmailAddress(Object bundleTokenEmailAddress) {
        this._bundleTokenEmailAddress = bundleTokenEmailAddress;
    }

    public void setBundleTokenForce(Object bundleTokenForce) {
        this._bundleTokenForce = bundleTokenForce;
    }

    public void setBundleTokenPassword(Object bundleTokenPassword) {
        this._bundleTokenPassword = bundleTokenPassword;
    }

    public void setBundleTokenPasswordFile(Object bundleTokenPasswordFile) {
        this._bundleTokenPasswordFile = bundleTokenPasswordFile;
    }

    public void setBundleUrl(Object bundleUrl) {
        this._bundleUrl = bundleUrl;
    }

    public void setConfigsDir(Object configsDir) {
        this._configsDir = configsDir;
    }

    public void setDockerDir(Object dockerDir) {
        this._dockerDir = dockerDir;
    }

    public void setDockerImageLiferay(Object dockerImageLiferay) {
        this._dockerImageLiferay = dockerImageLiferay;
    }

    public void setEnvironment(Object environment) {
        this._environment = environment;
    }

    public void setHomeDir(Object homeDir) {
        this._homeDir = homeDir;
    }

    public void setTargetPlatformVersion(Object targetPlatformVersion) {
        this._targetPlatformVersion = targetPlatformVersion;
    }

    private boolean _getProperty(Object object, String keySuffix, boolean defaultValue) {
        return GradleUtil.getProperty(object, "liferay.workspace." + keySuffix, defaultValue);
    }

    private Object _getProperty(Object object, String keySuffix, File defaultValue) {
        Object value = GradleUtil.getProperty(object, "liferay.workspace." + keySuffix);
        if (value instanceof String && Validator.isNull((String)((String)value))) {
            value = null;
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private String _getProperty(Object object, String keySuffix, String defaultValue) {
        return GradleUtil.getProperty(object, "liferay.workspace." + keySuffix, defaultValue);
    }
}

