/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.gradle.plugins.workspace;

import aQute.bnd.annotation.ProviderType;

import java.io.File;

import org.gradle.api.Plugin;
import org.gradle.api.Project;

/**
 * @author Andrea Di Giorgi
 */
@ProviderType
public interface ProjectConfigurator extends Plugin<Project> {

	public void configureRootProject(
		Project project, WorkspaceExtension workspaceExtension);

	public Iterable<File> getDefaultRootDirs();

	public String getName();

	public Iterable<File> getProjectDirs(File rootDir);

}