/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.util;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectUtil;

public class GradleUtil
extends com.liferay.gradle.util.GradleUtil {
    public static MavenArtifactRepository addMavenRepository(Project project, final Object url) {
        RepositoryHandler repositoryHandler = project.getRepositories();
        return repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository mavenArtifactRepository) {
                mavenArtifactRepository.setUrl(url);
            }
        });
    }

    public static String getProjectPath(File projectDir, File rootDir) {
        String projectPath = FileUtil.relativize((File)projectDir, (File)rootDir);
        return ":" + projectPath.replace(File.separatorChar, ':');
    }

    public static Object getProperty(Object object, String name) {
        DynamicObject dynamicObject = DynamicObjectUtil.asDynamicObject((Object)object);
        if (!dynamicObject.hasProperty(name)) {
            return null;
        }
        Object value = dynamicObject.getProperty(name);
        if (value instanceof String && Validator.isNull((String)((String)value))) {
            value = null;
        }
        return value;
    }

    public static boolean getProperty(Object object, String name, boolean defaultValue) {
        Object value = GradleUtil.getProperty(object, name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public static String getProperty(Object object, String name, String defaultValue) {
        Object value = GradleUtil.getProperty(object, name);
        if (value == null) {
            return defaultValue;
        }
        return GradleUtil.toString((Object)value);
    }

    public static File getProperty(Settings settings, String name, File defaultValue) {
        String value = GradleUtil.getProperty((Object)settings, name, (String)null);
        if (Validator.isNull((String)value)) {
            return defaultValue;
        }
        return new File(settings.getRootDir(), value);
    }
}

