/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.workspace.configurators.ModulesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.PluginsProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.RootProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.ThemesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.util.GradleUtil;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;

public class WorkspaceExtension {
    private static final String _BUNDLE_ARTIFACT_GROUP = "com.liferay";
    private static final String _BUNDLE_ARTIFACT_NAME = "portal-tomcat-bundle";
    private static final String _BUNDLE_ARTIFACT_VERSION = "7.0-ce-b2-20160105152151933";
    private static final String _BUNDLE_MAVEN_URL = "https://liferay-test-01.ci.cloudbees.com/job/liferay-bundle-publishing/lastSuccessfulBuild/artifact/build/m2_repo/";
    private static final String _CONFIGS_DIR = "configs";
    private static final String _ENVIRONMENT = "local";
    private static final String _HOME_DIR = "bundles";
    private Object _bundleArtifactGroup;
    private Object _bundleArtifactName;
    private Object _bundleArtifactVersion;
    private Object _bundleMavenUrl;
    private Object _configsDir;
    private Object _environment;
    private final Gradle _gradle;
    private Object _homeDir;
    private final Set<ProjectConfigurator> _projectConfigurators = new HashSet<ProjectConfigurator>();
    private final RootProjectConfigurator _rootProjectConfigurator = new RootProjectConfigurator();

    public WorkspaceExtension(Settings settings) {
        this._gradle = settings.getGradle();
        this._projectConfigurators.add(new ModulesProjectConfigurator(settings));
        this._projectConfigurators.add(new PluginsProjectConfigurator(settings));
        this._projectConfigurators.add(new ThemesProjectConfigurator(settings));
        this._bundleArtifactGroup = GradleUtil.getProperty((Object)settings, "liferay.workspace.bundle.artifact.group", _BUNDLE_ARTIFACT_GROUP);
        this._bundleArtifactName = GradleUtil.getProperty((Object)settings, "liferay.workspace.bundle.artifact.name", _BUNDLE_ARTIFACT_NAME);
        this._bundleArtifactVersion = GradleUtil.getProperty((Object)settings, "liferay.workspace.bundle.artifact.version", _BUNDLE_ARTIFACT_VERSION);
        this._bundleMavenUrl = GradleUtil.getProperty((Object)settings, "liferay.workspace.bundle.maven.url", _BUNDLE_MAVEN_URL);
        this._configsDir = GradleUtil.getProperty((Object)settings, "liferay.workspace.configs.dir", _CONFIGS_DIR);
        this._environment = GradleUtil.getProperty((Object)settings, "liferay.workspace.environment", _ENVIRONMENT);
        this._homeDir = GradleUtil.getProperty((Object)settings, "liferay.workspace.home.dir", _HOME_DIR);
    }

    public String getBundleArtifactGroup() {
        return GradleUtil.toString((Object)this._bundleArtifactGroup);
    }

    public String getBundleArtifactName() {
        return GradleUtil.toString((Object)this._bundleArtifactName);
    }

    public String getBundleArtifactVersion() {
        return GradleUtil.toString((Object)this._bundleArtifactVersion);
    }

    public String getBundleMavenUrl() {
        return GradleUtil.toString((Object)this._bundleMavenUrl);
    }

    public File getConfigsDir() {
        return GradleUtil.toFile((Project)this._gradle.getRootProject(), (Object)this._configsDir);
    }

    public String getEnvironment() {
        return GradleUtil.toString((Object)this._environment);
    }

    public File getHomeDir() {
        return GradleUtil.toFile((Project)this._gradle.getRootProject(), (Object)this._homeDir);
    }

    public Iterable<ProjectConfigurator> getProjectConfigurators() {
        return Collections.unmodifiableSet(this._projectConfigurators);
    }

    public RootProjectConfigurator getRootProjectConfigurator() {
        return this._rootProjectConfigurator;
    }

    public ProjectConfigurator propertyMissing(String name) {
        for (ProjectConfigurator projectConfigurator : this._projectConfigurators) {
            if (!name.equals(projectConfigurator.getName())) continue;
            return projectConfigurator;
        }
        throw new MissingPropertyException(name, ProjectConfigurator.class);
    }

    public void setBundleArtifactGroup(Object bundleArtifactGroup) {
        this._bundleArtifactGroup = bundleArtifactGroup;
    }

    public void setBundleArtifactName(Object bundleArtifactName) {
        this._bundleArtifactName = bundleArtifactName;
    }

    public void setBundleArtifactVersion(Object bundleArtifactVersion) {
        this._bundleArtifactVersion = bundleArtifactVersion;
    }

    public void setBundleMavenUrl(Object bundleMavenUrl) {
        this._bundleMavenUrl = bundleMavenUrl;
    }

    public void setConfigsDir(Object configsDir) {
        this._configsDir = configsDir;
    }

    public void setEnvironment(Object environment) {
        this._environment = environment;
    }

    public void setHomeDir(Object homeDir) {
        this._homeDir = homeDir;
    }
}

