/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.gulp.ExecuteGulpTask;
import com.liferay.gradle.plugins.gulp.GulpPlugin;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurators.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;

public class ThemesProjectConfigurator
extends BaseProjectConfigurator {
    public static final String CREATE_LIFERAY_THEME_JSON_TASK_NAME = "createLiferayThemeJson";
    private static final String _GULP_BUILD_TASK_NAME = "gulpBuild";
    private static final String _GULP_DEPLOY_TASK_NAME = "gulpDeploy";
    private static final String _NAME = "themes";

    public ThemesProjectConfigurator(Settings settings) {
        super(settings);
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        project.setBuildDir((Object)"build_gradle");
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        GradleUtil.applyPlugin((Project)project, GulpPlugin.class);
        Task createLiferayThemeJsonTask = this.addTaskCreateLiferayThemeJson(project, workspaceExtension);
        this.addTaskDeploy(project);
        this.configureTaskAssemble(project);
        this.configureTaskClean(project);
        this.configureTasksExecuteGulp(project, createLiferayThemeJsonTask);
        this.configureRootTaskDistBundle(project, "distBundleTar");
        this.configureRootTaskDistBundle(project, "distBundleZip");
    }

    @Override
    public String getName() {
        return _NAME;
    }

    protected Task addTaskCreateLiferayThemeJson(Project project, final WorkspaceExtension workspaceExtension) {
        Task task = project.task(CREATE_LIFERAY_THEME_JSON_TASK_NAME);
        final File liferayThemeJsonFile = project.file((Object)"liferay-theme.json");
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                HashMap<String, Object> map = new HashMap<String, Object>();
                File appServerDir = new File(workspaceExtension.getHomeDir(), "tomcat-7.0.62");
                map.put("appServerPath", appServerDir.getAbsolutePath());
                File appServerThemeDir = new File(appServerDir, "webapps/" + project.getName());
                map.put("appServerPathTheme", appServerThemeDir.getAbsolutePath());
                map.put("deployed", false);
                File deployDir = new File(workspaceExtension.getHomeDir(), "osgi/modules");
                map.put("deployPath", deployDir.getAbsolutePath());
                map.put("themeName", project.getName());
                String json = JsonOutput.toJson(Collections.singletonMap("LiferayTheme", map));
                try {
                    Files.write(liferayThemeJsonFile.toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException ioe) {
                    throw new GradleException(ioe.getMessage(), (Throwable)ioe);
                }
            }
        });
        return task;
    }

    protected Task addTaskDeploy(Project project) {
        Task task = project.task("deploy");
        task.dependsOn(new Object[]{_GULP_DEPLOY_TASK_NAME});
        task.setDescription("Assembles the theme and deploys it to Liferay.");
        return task;
    }

    protected void configureRootTaskDistBundle(final Project project, String rootTaskName) {
        CopySpec copySpec = (CopySpec)GradleUtil.getTask((Project)project.getRootProject(), (String)rootTaskName);
        copySpec.into((Object)"osgi/modules", (Closure)new Closure<Void>(null){

            public void doCall(CopySpec copySpec) {
                ConfigurableFileTree fileTree = project.fileTree((Object)"dist");
                fileTree.builtBy(new Object[]{ThemesProjectConfigurator._GULP_DEPLOY_TASK_NAME});
                fileTree.include(new String[]{"*.war"});
                copySpec.from(new Object[]{fileTree});
            }
        });
    }

    protected void configureTaskAssemble(Project project) {
        Task task = GradleUtil.getTask((Project)project, (String)"assemble");
        task.dependsOn(new Object[]{_GULP_BUILD_TASK_NAME});
    }

    protected void configureTaskClean(Project project) {
        Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        delete.delete(new Object[]{"build", "dist"});
        delete.dependsOn(new Object[]{"clean" + StringUtil.capitalize((String)"npmInstall")});
    }

    protected void configureTaskExecuteGulp(ExecuteGulpTask executeGulpTask, Task createLiferayThemeJsonTask) {
        executeGulpTask.dependsOn(new Object[]{createLiferayThemeJsonTask, "npmInstall"});
    }

    protected void configureTasksExecuteGulp(Project project, final Task createLiferayThemeJsonTask) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteGulpTask.class, (Action)new Action<ExecuteGulpTask>(){

            public void execute(ExecuteGulpTask executeGulpTask) {
                ThemesProjectConfigurator.this.configureTaskExecuteGulp(executeGulpTask, createLiferayThemeJsonTask);
            }
        });
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                Path dirNamePath = dirPath.getFileName();
                String dirName = dirNamePath.toString();
                if (dirName.equals("build") || dirName.equals("build_gradle") || dirName.equals("node_modules")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (Files.exists(dirPath.resolve("package.json"), new LinkOption[0])) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }
}

