/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import de.undercouch.gradle.tasks.download.Download;
import groovy.lang.Closure;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.api.tasks.bundling.Tar;
import org.gradle.api.tasks.bundling.Zip;

public class RootProjectConfigurator
implements Plugin<Project> {
    public static final String BUNDLE_CONFIGURATION_NAME = "bundle";
    public static final String BUNDLE_GROUP = "bundle";
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String DIST_BUNDLE_TAR_TASK_NAME = "distBundleTar";
    public static final String DIST_BUNDLE_ZIP_TASK_NAME = "distBundleZip";
    public static final String DOWNLOAD_BUNDLE_TASK_NAME = "downloadBundle";
    public static final String INIT_BUNDLE_TASK_NAME = "initBundle";

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        this.addTaskClean(project);
        Download downloadBundleTask = this.addTaskDownloadBundle(project, workspaceExtension);
        Tar distBundleTarTask = this.addTaskDistBundle(project, DIST_BUNDLE_TAR_TASK_NAME, Tar.class, downloadBundleTask, workspaceExtension);
        distBundleTarTask.setCompression(Compression.GZIP);
        distBundleTarTask.setExtension("tar.gz");
        this.addTaskDistBundle(project, DIST_BUNDLE_ZIP_TASK_NAME, Zip.class, downloadBundleTask, workspaceExtension);
        this.addTaskInitBundle(project, downloadBundleTask, workspaceExtension);
    }

    protected Delete addTaskClean(final Project project) {
        Delete delete = (Delete)GradleUtil.addTask((Project)project, (String)CLEAN_TASK_NAME, Delete.class);
        delete.delete(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return project.getBuildDir();
            }
        }});
        delete.setDescription("Deletes the build directory.");
        return delete;
    }

    protected <T extends AbstractArchiveTask> T addTaskDistBundle(Project project, String taskName, Class<T> clazz, Download downloadBundleTask, WorkspaceExtension workspaceExtension) {
        final AbstractArchiveTask task = (AbstractArchiveTask)GradleUtil.addTask((Project)project, (String)taskName, clazz);
        this.configureTaskCopyBundle((AbstractCopyTask)task, downloadBundleTask, workspaceExtension);
        task.setBaseName(project.getName());
        task.setDestinationDir(project.getBuildDir());
        task.setGroup("bundle");
        task.setIncludeEmptyDirs(false);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                if (Validator.isNotNull((String)task.getDescription())) {
                    return;
                }
                task.setDescription("Assembles the Liferay bundle and zips it up into '" + project.relativePath((Object)task.getArchivePath()) + "'.");
            }
        });
        return (T)task;
    }

    protected Download addTaskDownloadBundle(Project project, final WorkspaceExtension workspaceExtension) {
        final Download download = (Download)GradleUtil.addTask((Project)project, (String)DOWNLOAD_BUNDLE_TASK_NAME, Download.class);
        File destinationDir = new File(System.getProperty("user.home"), ".liferay/bundles");
        destinationDir.mkdirs();
        download.dest((Object)destinationDir);
        download.onlyIfNewer(true);
        download.setDescription("Downloads the Liferay bundle zip file.");
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Object src = download.getSrc();
                if (src != null) {
                    if (src instanceof List) {
                        List srcList = (List)src;
                        if (!srcList.isEmpty()) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                String bundleUrl = workspaceExtension.getBundleUrl();
                bundleUrl = bundleUrl.replace(" ", "%20");
                try {
                    download.src((Object)bundleUrl);
                }
                catch (MalformedURLException murle) {
                    throw new GradleException(murle.getMessage(), (Throwable)murle);
                }
            }
        });
        return download;
    }

    protected Copy addTaskInitBundle(Project project, Download downloadBundleTask, final WorkspaceExtension workspaceExtension) {
        final Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)INIT_BUNDLE_TASK_NAME, Copy.class);
        this.configureTaskCopyBundle((AbstractCopyTask)copy, downloadBundleTask, workspaceExtension);
        copy.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                Project project = copy.getProject();
                project.delete(new Object[]{copy.getDestinationDir()});
            }
        });
        copy.into((Object)new Closure<Void>((Object)project){

            public File doCall() {
                return workspaceExtension.getHomeDir();
            }
        });
        copy.setGroup("bundle");
        copy.setIncludeEmptyDirs(false);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                if (Validator.isNotNull((String)copy.getDescription())) {
                    return;
                }
                copy.setDescription("Downloads and unzips the bundle into '" + project.relativePath((Object)copy.getDestinationDir()) + "'.");
            }
        });
        return copy;
    }

    protected void configureTaskCopyBundle(AbstractCopyTask abstractCopyTask, final Download downloadBundleTask, final WorkspaceExtension workspaceExtension) {
        final Project project = abstractCopyTask.getProject();
        abstractCopyTask.dependsOn(new Object[]{downloadBundleTask});
        abstractCopyTask.from((Object)new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                File dir = downloadBundleTask.getDest();
                URL url = (URL)downloadBundleTask.getSrc();
                String fileName = url.toString();
                fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                File file = new File(dir, fileName);
                if (fileName.endsWith(".tar.gz")) {
                    return project.tarTree((Object)file);
                }
                return project.zipTree((Object)file);
            }
        }, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.eachFile((Action)new StripPathSegmentsAction(1));
            }
        });
        abstractCopyTask.from((Object)new Closure<Void>((Object)project){

            public FileCollection doCall() {
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("dir", workspaceExtension.getConfigsDir());
                args.put("exclude", "**/.touch");
                List<String> includes = Arrays.asList("common/", workspaceExtension.getEnvironment() + "/");
                args.put("includes", includes);
                return project.fileTree(args);
            }
        }, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.eachFile((Action)new StripPathSegmentsAction(1));
            }
        });
    }
}

