/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurators.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;

public class ThemesProjectConfigurator
extends BaseProjectConfigurator {
    private static final String _NAME = "themes";

    public ThemesProjectConfigurator(Settings settings) {
        super(settings);
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        GradleUtil.applyPlugin((Project)project, LiferayThemePlugin.class);
        this.configureLiferay(project, workspaceExtension);
        this.configureRootTaskDistBundle(project, "distBundleTar");
        this.configureRootTaskDistBundle(project, "distBundleZip");
    }

    @Override
    public String getName() {
        return _NAME;
    }

    protected void configureLiferay(Project project, WorkspaceExtension workspaceExtension) {
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        liferayExtension.setAppServerParentDir((Object)workspaceExtension.getHomeDir());
    }

    protected void configureRootTaskDistBundle(final Project project, String rootTaskName) {
        CopySpec copySpec = (CopySpec)GradleUtil.getTask((Project)project.getRootProject(), (String)rootTaskName);
        copySpec.into((Object)"osgi/modules", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{ThemesProjectConfigurator.this.getWarFile(project)});
                configurableFileCollection.builtBy(new Object[]{"assemble"});
                copySpec.from(new Object[]{ThemesProjectConfigurator.this.getWarFile(project)});
            }
        });
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                Path dirNamePath = dirPath.getFileName();
                String dirName = dirNamePath.toString();
                if (dirName.equals("build") || dirName.equals("build_gradle") || dirName.equals("node_modules")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (Files.exists(dirPath.resolve("package.json"), new LinkOption[0])) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    protected File getWarFile(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        return project.file((Object)("dist/" + basePluginConvention.getArchivesBaseName() + ".war"));
    }
}

