/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.util.GradleUtil;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import groovy.lang.Closure;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.api.tasks.bundling.Tar;
import org.gradle.api.tasks.bundling.Zip;

public class RootProjectConfigurator
implements Plugin<Project> {
    public static final String BUNDLE_CONFIGURATION_NAME = "bundle";
    public static final String BUNDLE_GROUP = "bundle";
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String DIST_BUNDLE_TAR_TASK_NAME = "distBundleTar";
    public static final String DIST_BUNDLE_ZIP_TASK_NAME = "distBundleZip";
    public static final String INIT_BUNDLE_TASK_NAME = "initBundle";

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        Configuration bundleConfiguration = this.addConfigurationBundle(project, workspaceExtension);
        this.addRepositoryBundle(project, workspaceExtension);
        this.addTaskClean(project);
        Tar distBundleTarTask = this.addTaskDistBundle(project, DIST_BUNDLE_TAR_TASK_NAME, Tar.class, bundleConfiguration, workspaceExtension);
        distBundleTarTask.setCompression(Compression.GZIP);
        distBundleTarTask.setExtension("tar.gz");
        this.addTaskDistBundle(project, DIST_BUNDLE_ZIP_TASK_NAME, Zip.class, bundleConfiguration, workspaceExtension);
        this.addTaskInitBundle(project, bundleConfiguration, workspaceExtension);
    }

    protected Configuration addConfigurationBundle(final Project project, final WorkspaceExtension workspaceExtension) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)"bundle");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                GradleUtil.addDependency((Project)project, (String)"bundle", (String)workspaceExtension.getBundleArtifactGroup(), (String)workspaceExtension.getBundleArtifactName(), (String)workspaceExtension.getBundleArtifactVersion());
            }
        });
        configuration.setDescription("Configures the Liferay bundle to use for your project.");
        return configuration;
    }

    protected void addRepositoryBundle(Project project, final WorkspaceExtension workspaceExtension) {
        GradleUtil.addMavenRepository(project, new Callable<String>(){

            @Override
            public String call() throws Exception {
                return workspaceExtension.getBundleMavenUrl();
            }
        });
    }

    protected Delete addTaskClean(final Project project) {
        Delete delete = (Delete)GradleUtil.addTask((Project)project, (String)CLEAN_TASK_NAME, Delete.class);
        delete.delete(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return project.getBuildDir();
            }
        }});
        delete.setDescription("Deletes the build directory.");
        return delete;
    }

    protected <T extends AbstractArchiveTask> T addTaskDistBundle(Project project, String taskName, Class<T> clazz, Configuration bundleConfiguration, WorkspaceExtension workspaceExtension) {
        final AbstractArchiveTask task = (AbstractArchiveTask)GradleUtil.addTask((Project)project, (String)taskName, clazz);
        this.configureTaskCopyBundle((AbstractCopyTask)task, bundleConfiguration, workspaceExtension);
        task.setBaseName(project.getName());
        task.setDestinationDir(project.getBuildDir());
        task.setGroup("bundle");
        task.setIncludeEmptyDirs(false);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                task.setDescription("Assembles the Liferay bundle and zips it up into '" + project.relativePath((Object)task.getArchivePath()) + "'.");
            }
        });
        return (T)task;
    }

    protected Copy addTaskInitBundle(Project project, Configuration bundleConfiguration, final WorkspaceExtension workspaceExtension) {
        final Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)INIT_BUNDLE_TASK_NAME, Copy.class);
        this.configureTaskCopyBundle((AbstractCopyTask)copy, bundleConfiguration, workspaceExtension);
        copy.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                Project project = copy.getProject();
                project.delete(new Object[]{copy.getDestinationDir()});
            }
        });
        copy.into((Object)new Closure<Void>(null){

            public File doCall() {
                return workspaceExtension.getHomeDir();
            }
        });
        copy.setGroup("bundle");
        copy.setIncludeEmptyDirs(false);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                copy.setDescription("Downloads and unzips the bundle into '" + project.relativePath((Object)copy.getDestinationDir()) + "'.");
            }
        });
        return copy;
    }

    protected void configureTaskCopyBundle(final AbstractCopyTask abstractCopyTask, final Configuration bundleConfiguration, final WorkspaceExtension workspaceExtension) {
        abstractCopyTask.from((Object)new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                Project project = abstractCopyTask.getProject();
                if (!GradleUtil.isInTaskGraph((Task)abstractCopyTask)) {
                    return project.files(new Object[0]);
                }
                File file = bundleConfiguration.getSingleFile();
                String fileName = file.getName();
                if (fileName.endsWith(".tar.gz")) {
                    return project.tarTree((Object)file);
                }
                return project.zipTree((Object)file);
            }
        }, (Closure)new Closure<Void>(null){

            public void doCall(CopySpec copySpec) {
                copySpec.eachFile((Action)new StripPathSegmentsAction(1));
            }
        });
        abstractCopyTask.from((Object)new Closure<Void>(null){

            public FileCollection doCall() {
                Project project = abstractCopyTask.getProject();
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("dir", workspaceExtension.getConfigsDir());
                args.put("exclude", "**/.touch");
                List<String> includes = Arrays.asList("common/", workspaceExtension.getEnvironment() + "/");
                args.put("includes", includes);
                return project.fileTree(args);
            }
        }, (Closure)new Closure<Void>(null){

            public void doCall(CopySpec copySpec) {
                copySpec.eachFile((Action)new StripPathSegmentsAction(1));
            }
        });
    }
}

