/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.LiferayPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.poshi.runner.PoshiRunnerPlugin;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurators.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.CopySourceSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.ExtensionAware;

public class ModulesProjectConfigurator
extends BaseProjectConfigurator {
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private static final String _NAME = "modules";
    private boolean _defaultRepositoryEnabled;

    public ModulesProjectConfigurator(Settings settings) {
        super(settings);
        this._defaultRepositoryEnabled = GradleUtil.getProperty((Object)settings, "liferay.workspace.modules.default.repository.enabled", true);
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        GradleUtil.applyPlugin((Project)project, LiferayPlugin.class);
        GradleUtil.applyPlugin((Project)project, PoshiRunnerPlugin.class);
        this.addRepositoryDefault(project, workspaceExtension);
        this.configureLiferay(project, workspaceExtension);
        this.configureRootTaskDistBundle(project, "distBundleTar");
        this.configureRootTaskDistBundle(project, "distBundleZip");
    }

    @Override
    public String getName() {
        return _NAME;
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    public void setDefaultRepositoryEnabled(boolean defaultRepositoryEnabled) {
        this._defaultRepositoryEnabled = defaultRepositoryEnabled;
    }

    protected MavenArtifactRepository addRepositoryDefault(Project project, WorkspaceExtension workspaceExtension) {
        if (!this.isDefaultRepositoryEnabled()) {
            return null;
        }
        return GradleUtil.addMavenRepository(project, "http://cdn.repository.liferay.com/nexus/content/groups/public");
    }

    protected void configureLiferay(Project project, WorkspaceExtension workspaceExtension) {
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        liferayExtension.setAppServerParentDir((Object)workspaceExtension.getHomeDir());
    }

    protected void configureRootTaskDistBundle(final Project project, String rootTaskName) {
        CopySpec copySpec = (CopySpec)GradleUtil.getTask((Project)project.getRootProject(), (String)rootTaskName);
        copySpec.into((Object)"osgi/modules", (Closure)new Closure<Void>(null){

            public void doCall(CopySourceSpec copySourceSpec) {
                Task jarTask = GradleUtil.getTask((Project)project, (String)"jar");
                copySourceSpec.from(new Object[]{jarTask});
            }
        });
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                if (Files.exists(dirPath.resolve("bnd.bnd"), new LinkOption[0])) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }
}

