/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurators.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurators.RootProjectConfigurator;
import com.liferay.gradle.plugins.workspace.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;

public class WorkspacePlugin
implements Plugin<Settings> {
    public static final String EXTENSION_NAME = "liferayWorkspace";
    public static final String PROPERTY_PREFIX = "liferay.workspace.";
    private static final Map<String, ProjectConfigurator> _projectConfiguratorsMap = new HashMap<String, ProjectConfigurator>();

    public void apply(Settings settings) {
        Gradle gradle = settings.getGradle();
        final WorkspaceExtension workspaceExtension = this.addWorkspaceExtension(settings);
        for (ProjectConfigurator projectConfigurator : workspaceExtension.getProjectConfigurators()) {
            File rootDir = projectConfigurator.getDefaultRootDir();
            Iterable<File> projectDirs = projectConfigurator.getProjectDirs(rootDir);
            for (File projectDir : projectDirs) {
                String projectPath = GradleUtil.getProjectPath(projectDir, settings.getRootDir());
                settings.include(new String[]{projectPath});
                _projectConfiguratorsMap.put(projectPath, projectConfigurator);
            }
        }
        gradle.beforeProject((Closure)new Closure<Void>(null){

            public void doCall(Project project) {
                RootProjectConfigurator plugin = null;
                plugin = project.getParent() == null ? workspaceExtension.getRootProjectConfigurator() : (Plugin)_projectConfiguratorsMap.get(project.getPath());
                if (plugin != null) {
                    plugin.apply(project);
                }
            }
        });
    }

    protected WorkspaceExtension addWorkspaceExtension(Settings settings) {
        ExtensionAware extensionAware = (ExtensionAware)settings.getGradle();
        ExtensionContainer extensionContainer = extensionAware.getExtensions();
        return (WorkspaceExtension)extensionContainer.create(EXTENSION_NAME, WorkspaceExtension.class, new Object[]{settings});
    }
}

