/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.LiferayPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.gulp.ExecuteGulpTask;
import com.liferay.gradle.plugins.gulp.GulpPlugin;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.tasks.UpdatePropertiesTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySourceSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Tar;
import org.gradle.api.tasks.bundling.Zip;

public class WorkspacePlugin
implements Plugin<Project> {
    public static final String BUNDLE_CONFIGURATION_NAME = "bundle";
    public static final String CREATE_LIFERAY_THEME_JSON_TASK_NAME = "createLiferayThemeJson";
    public static final String DIST_BUNDLE_TAR_TASK_NAME = "distBundleTar";
    public static final String DIST_BUNDLE_ZIP_TASK_NAME = "distBundleZip";
    public static final String INIT_BUNDLE_TASK_NAME = "initBundle";
    public static final String PLUGIN_NAME = "workspace";
    public static final String UPDATE_SDK_PROPERTIES_TASK_NAME = "updateSDKProperties";
    private static final String _GULP_BUILD_TASK_NAME = "gulpBuild";
    private static final String _GULP_DEPLOY_TASK_NAME = "gulpDeploy";

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.addExtension((ExtensionAware)project, (String)PLUGIN_NAME, WorkspaceExtension.class);
        Configuration bundleConfiguration = this.addConfigurationBundle(project, workspaceExtension);
        this.addRepositoryBundle(project, workspaceExtension);
        Tar distBundleTarTask = this.addTaskDistBundle(project, DIST_BUNDLE_TAR_TASK_NAME, Tar.class, bundleConfiguration);
        Zip distBundleZipTask = this.addTaskDistBundle(project, DIST_BUNDLE_ZIP_TASK_NAME, Zip.class, bundleConfiguration);
        AbstractArchiveTask[] distBundleTasks = new AbstractArchiveTask[]{distBundleTarTask, distBundleZipTask};
        Copy initBundleTask = this.addTaskInitBundle(project, workspaceExtension, bundleConfiguration);
        this.configureModules(project, workspaceExtension, distBundleTasks);
        this.configurePluginsSDK(project, workspaceExtension, initBundleTask, distBundleTasks);
        this.configureThemes(project, workspaceExtension, distBundleTasks);
    }

    protected Configuration addConfigurationBundle(Project project, WorkspaceExtension workspaceExtension) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)BUNDLE_CONFIGURATION_NAME);
        configuration.setDescription("Configures the Liferay bundle to use for your project.");
        GradleUtil.addDependency((Project)project, (String)BUNDLE_CONFIGURATION_NAME, (String)workspaceExtension.getBundleArtifactGroup(), (String)workspaceExtension.getBundleArtifactName(), (String)workspaceExtension.getBundleArtifactVersion());
        return configuration;
    }

    protected MavenArtifactRepository addRepository(Project project, final String url) {
        RepositoryHandler repositoryHandler = project.getRepositories();
        return repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository mavenArtifactRepository) {
                mavenArtifactRepository.setUrl((Object)url);
            }
        });
    }

    protected MavenArtifactRepository addRepositoryBundle(Project project, WorkspaceExtension workspaceExtension) {
        return this.addRepository(project, workspaceExtension.getBundleMavenUrl());
    }

    protected MavenArtifactRepository addRepositoryModules(Project project) {
        return this.addRepository(project, "http://cdn.repository.liferay.com/nexus/content/groups/public");
    }

    protected Task addTaskCreateLiferayThemeJson(Project project, final WorkspaceExtension workspaceExtension) {
        Task task = project.task(CREATE_LIFERAY_THEME_JSON_TASK_NAME);
        final File liferayThemeJsonFile = project.file((Object)"liferay-theme.json");
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                HashMap<String, Object> map = new HashMap<String, Object>();
                File appServerDir = new File(workspaceExtension.getHomeDir(), "tomcat-7.0.62");
                map.put("appServerPath", appServerDir.getAbsolutePath());
                File appServerThemeDir = new File(appServerDir, "webapps/" + project.getName());
                map.put("appServerPathTheme", appServerThemeDir.getAbsolutePath());
                map.put("deployed", false);
                File deployDir = new File(workspaceExtension.getHomeDir(), "deploy");
                map.put("deployPath", deployDir.getAbsolutePath());
                map.put("themeName", project.getName());
                String json = JsonOutput.toJson(Collections.singletonMap("LiferayTheme", map));
                try {
                    Files.write(liferayThemeJsonFile.toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException ioe) {
                    throw new GradleException(ioe.getMessage(), (Throwable)ioe);
                }
            }
        });
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return liferayThemeJsonFile.exists();
            }
        });
        return task;
    }

    protected <T extends AbstractArchiveTask> T addTaskDistBundle(final Project project, String taskName, Class<T> clazz, final Configuration bundleConfiguration) {
        AbstractArchiveTask task = (AbstractArchiveTask)GradleUtil.addTask((Project)project, (String)taskName, clazz);
        task.from((Object)new Callable<FileTree>(){

            @Override
            public FileTree call() throws Exception {
                File file = bundleConfiguration.getSingleFile();
                String fileName = file.getName();
                if (fileName.endsWith(".tar.gz")) {
                    return project.tarTree((Object)file);
                }
                return project.zipTree((Object)file);
            }
        }, (Closure)new Closure<Void>(null){

            public void doCall(CopySpec copySpec) {
                copySpec.eachFile((Action)new StripPathSegmentsAction(1));
            }
        });
        task.setBaseName(project.getName());
        task.setDescription("Assembles the bundle and zips it up.");
        task.setDestinationDir(project.getBuildDir());
        task.setIncludeEmptyDirs(false);
        return (T)task;
    }

    protected Copy addTaskInitBundle(final Project project, WorkspaceExtension workspaceExtension, final Configuration bundleConfiguration) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)INIT_BUNDLE_TASK_NAME, Copy.class);
        copy.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                project.delete(new Object[]{copy.getDestinationDir()});
            }
        });
        copy.from((Object)new Callable<FileTree>(){

            @Override
            public FileTree call() throws Exception {
                File file = bundleConfiguration.getSingleFile();
                String fileName = file.getName();
                if (fileName.endsWith(".tar.gz")) {
                    return project.tarTree((Object)file);
                }
                return project.zipTree((Object)file);
            }
        }, (Closure)new Closure<Void>(null){

            public void doCall(CopySpec copySpec) {
                copySpec.eachFile((Action)new StripPathSegmentsAction(1));
            }
        });
        Project rootProject = project.getRootProject();
        copy.from(new Object[]{rootProject.file((Object)"configs/common"), rootProject.file((Object)("configs/" + workspaceExtension.getEnvironment()))});
        copy.into((Object)workspaceExtension.getHomeDir());
        copy.setDescription("Downloads and unzips the bundle into " + workspaceExtension.getHomeDir() + ".");
        copy.setIncludeEmptyDirs(false);
        return copy;
    }

    protected UpdatePropertiesTask addTaskUpdateSDKProperties(Project project, WorkspaceExtension workspaceExtension) {
        UpdatePropertiesTask updatePropertiesTask = (UpdatePropertiesTask)GradleUtil.addTask((Project)project, (String)UPDATE_SDK_PROPERTIES_TASK_NAME, UpdatePropertiesTask.class);
        updatePropertiesTask.property("app.server.parent.dir", FileUtil.getAbsolutePath((File)workspaceExtension.getHomeDir()));
        String userName = System.getProperty("user.name");
        File sdkPropertiesFile = new File(workspaceExtension.getPluginsSDKDir(), "build." + userName + ".properties");
        updatePropertiesTask.setPropertiesFile(sdkPropertiesFile);
        return updatePropertiesTask;
    }

    protected void configureModules(Project project, final WorkspaceExtension workspaceExtension, final AbstractArchiveTask[] distBundleTasks) {
        Project modulesProject = GradleUtil.getProject((Project)project, (File)workspaceExtension.getModulesDir());
        if (modulesProject == null) {
            return;
        }
        Action<Project> action = new Action<Project>(){

            public void execute(Project project) {
                Set subprojects = project.getSubprojects();
                if (!subprojects.isEmpty()) {
                    return;
                }
                GradleUtil.applyPlugin((Project)project, LiferayPlugin.class);
                LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
                liferayExtension.setAppServerParentDir((Object)workspaceExtension.getHomeDir());
                for (AbstractArchiveTask abstractArchiveTask : distBundleTasks) {
                    abstractArchiveTask.into((Object)"deploy", (Closure)new Closure<Void>(null){

                        public void doCall(CopySourceSpec copySourceSpec) {
                            copySourceSpec.from(new Object[]{"jar"});
                        }
                    });
                }
                if (workspaceExtension.isModulesDefaultRepositoryEnabled()) {
                    WorkspacePlugin.this.addRepositoryModules(project);
                }
            }
        };
        modulesProject.subprojects((Action)action);
    }

    protected void configurePluginsSDK(Project project, WorkspaceExtension workspaceExtension, Copy initBundleTask, AbstractArchiveTask[] distBundleTasks) {
        final Project pluginsSDKProject = GradleUtil.getProject((Project)project, (File)workspaceExtension.getPluginsSDKDir());
        if (pluginsSDKProject == null) {
            return;
        }
        AntBuilder antBuilder = pluginsSDKProject.getAnt();
        antBuilder.importBuild((Object)"build.xml");
        final Task warTask = GradleUtil.getTask((Project)pluginsSDKProject, (String)"war");
        File homeDir = workspaceExtension.getHomeDir();
        if (!homeDir.exists()) {
            warTask.dependsOn(new Object[]{initBundleTask});
        }
        UpdatePropertiesTask updateSDKPropertiesTask = this.addTaskUpdateSDKProperties(pluginsSDKProject, workspaceExtension);
        Task buildTask = pluginsSDKProject.task("build");
        buildTask.dependsOn(new Object[]{updateSDKPropertiesTask, warTask});
        for (AbstractArchiveTask abstractArchiveTask : distBundleTasks) {
            abstractArchiveTask.into((Object)"deploy", (Closure)new Closure<Void>(null){

                public void doCall(CopySpec copySpec) {
                    ConfigurableFileTree configurableFileTree = pluginsSDKProject.fileTree((Object)"dist");
                    configurableFileTree.builtBy(new Object[]{warTask});
                    configurableFileTree.include(new String[]{"*.war"});
                    copySpec.from(new Object[]{configurableFileTree});
                }
            });
        }
    }

    protected void configureThemes(Project project, final WorkspaceExtension workspaceExtension, final AbstractArchiveTask[] distBundleTasks) {
        Project themesProject = GradleUtil.getProject((Project)project, (File)workspaceExtension.getThemesDir());
        if (themesProject == null) {
            return;
        }
        Action<Project> action = new Action<Project>(){

            public void execute(final Project project) {
                Set subproject = project.getSubprojects();
                if (!subproject.isEmpty()) {
                    return;
                }
                project.setBuildDir((Object)"build_gradle");
                GradleUtil.applyPlugin((Project)project, BasePlugin.class);
                GradleUtil.applyPlugin((Project)project, GulpPlugin.class);
                Task assembleTask = GradleUtil.getTask((Project)project, (String)"assemble");
                assembleTask.dependsOn(new Object[]{WorkspacePlugin._GULP_BUILD_TASK_NAME});
                final Task createLiferayThemeJsonTask = WorkspacePlugin.this.addTaskCreateLiferayThemeJson(project, workspaceExtension);
                Delete cleanTask = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
                cleanTask.delete(new Object[]{"build", "dist"});
                cleanTask.dependsOn(new Object[]{"clean" + StringUtil.capitalize((String)"npmInstall")});
                Task deployTask = project.task("deploy");
                deployTask.dependsOn(new Object[]{WorkspacePlugin._GULP_DEPLOY_TASK_NAME});
                for (AbstractArchiveTask abstractArchiveTask : distBundleTasks) {
                    abstractArchiveTask.into((Object)"deploy", (Closure)new Closure<Void>(null){

                        public void doCall(CopySpec copySpec) {
                            ConfigurableFileTree fileTree = project.fileTree((Object)"dist");
                            fileTree.builtBy(new Object[]{WorkspacePlugin._GULP_DEPLOY_TASK_NAME});
                            fileTree.include(new String[]{"*.war"});
                            copySpec.from(new Object[]{fileTree});
                        }
                    });
                }
                TaskContainer taskContainer = project.getTasks();
                taskContainer.withType(ExecuteGulpTask.class, (Action)new Action<ExecuteGulpTask>(){

                    public void execute(ExecuteGulpTask executeGulpTask) {
                        executeGulpTask.dependsOn(new Object[]{createLiferayThemeJsonTask, "npmInstall"});
                    }
                });
            }
        };
        themesProject.subprojects((Action)action);
    }
}

