/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.wedeploy;

import com.liferay.gradle.plugins.wedeploy.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.Exec;

public class WeDeployPlugin
implements Plugin<Project> {
    public static final String DELETE_WEDEPLOY_TASK_NAME = "deleteWeDeploy";
    public static final String DEPLOY_WEDEPLOY_TASK_NAME = "deployWeDeploy";

    public void apply(Project project) {
        String wedeployProject = this._getProperty(project, ".wedeploy.project");
        String wedeployRemote = this._getProperty(project, ".wedeploy.remote");
        this._addTaskDeleteWeDeploy(project, wedeployProject, wedeployRemote);
        this._addTaskDeployWeDeploy(project, wedeployProject, wedeployRemote);
    }

    private Exec _addTaskDeleteWeDeploy(Project project, String wedeployProject, String wedeployRemote) {
        Exec exec = (Exec)GradleUtil.addTask((Project)project, (String)DELETE_WEDEPLOY_TASK_NAME, Exec.class);
        exec.args(new Object[]{"delete", "--force"});
        if (Validator.isNotNull((String)wedeployProject)) {
            exec.args(new Object[]{"--project", wedeployProject});
        }
        if (Validator.isNotNull((String)wedeployRemote)) {
            exec.args(new Object[]{"--remote", wedeployRemote});
        }
        File wedeployJsonFile = project.file((Object)"wedeploy.json");
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map wedeployJsonMap = (Map)jsonSlurper.parse(wedeployJsonFile);
        String wedeployId = (String)wedeployJsonMap.get("id");
        exec.args(new Object[]{"--service", wedeployId});
        exec.setExecutable((Object)"we");
        exec.setDescription("Deletes the project from WeDeploy.");
        exec.setGroup("upload");
        return exec;
    }

    private Exec _addTaskDeployWeDeploy(Project project, String wedeployProject, String wedeployRemote) {
        Exec exec = (Exec)GradleUtil.addTask((Project)project, (String)DEPLOY_WEDEPLOY_TASK_NAME, Exec.class);
        exec.args(new Object[]{"deploy"});
        if (Validator.isNotNull((String)wedeployProject)) {
            exec.args(new Object[]{"--project", wedeployProject});
        }
        if (Validator.isNotNull((String)wedeployRemote)) {
            exec.args(new Object[]{"--remote", wedeployRemote});
        }
        exec.setExecutable((Object)"we");
        exec.setDescription("Deploys the project to WeDeploy.");
        exec.setGroup("upload");
        return exec;
    }

    private String _getProperty(Project project, String suffix) {
        File rootDir = project.getRootDir();
        Properties properties = GradleUtil.getGradleProperties((File)rootDir);
        if (properties != null) {
            for (Object key : properties.keySet()) {
                String s = (String)key;
                if (!s.endsWith(suffix)) continue;
                return GradleUtil.toString((Object)properties.get(key));
            }
        }
        return null;
    }
}

