/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tlddoc.builder.tasks;

import com.liferay.gradle.plugins.tlddoc.builder.internal.util.TLDUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.HashMap;
import org.gradle.api.AntBuilder;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class ValidateSchemaTask
extends SourceTask {
    private boolean _dtdDisabled;
    private boolean _fullChecking = true;
    private boolean _lenient;
    private Object _xmlParserClassName;
    private FileCollection _xmlParserClasspath;

    @Input
    @Optional
    public String getXMLParserClassName() {
        return GradleUtil.toString((Object)this._xmlParserClassName);
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getXMLParserClasspath() {
        return this._xmlParserClasspath;
    }

    @Input
    public boolean isDTDDisabled() {
        return this._dtdDisabled;
    }

    @Input
    public boolean isFullChecking() {
        return this._fullChecking;
    }

    @Input
    public boolean isLenient() {
        return this._lenient;
    }

    public void setDTDDisabled(boolean dtdDisabled) {
        this._dtdDisabled = dtdDisabled;
    }

    public void setFullChecking(boolean fullChecking) {
        this._fullChecking = fullChecking;
    }

    public void setLenient(boolean lenient) {
        this._lenient = lenient;
    }

    public void setXMLParserClassName(Object xmlParserClassName) {
        this._xmlParserClassName = xmlParserClassName;
    }

    public void setXMLParserClasspath(FileCollection xmlParserClasspath) {
        this._xmlParserClasspath = xmlParserClasspath;
    }

    @TaskAction
    public void validateSchema() {
        FileCollection xmlParserClasspath;
        Project project = this.getProject();
        final AntBuilder antBuilder = project.getAnt();
        HashMap<String, Object> args = new HashMap<String, Object>();
        String xmlParserClassName = this.getXMLParserClassName();
        if (Validator.isNotNull((String)xmlParserClassName)) {
            args.put("classname", xmlParserClassName);
        }
        if ((xmlParserClasspath = this.getXMLParserClasspath()) != null && !xmlParserClasspath.isEmpty()) {
            args.put("classpath", xmlParserClasspath.getAsPath());
        }
        args.put("disableDTD", this.isDTDDisabled());
        args.put("fullchecking", this.isFullChecking());
        args.put("lenient", this.isLenient());
        Closure<Void> closure = new Closure<Void>((Object)antBuilder){

            public void doCall() {
                FileTree fileTree = ValidateSchemaTask.this.getSource();
                Logger logger = ValidateSchemaTask.this.getLogger();
                fileTree.addToAntBuilder((Object)antBuilder, "fileset", FileCollection.AntType.FileSet);
                for (File file : fileTree.getFiles()) {
                    try {
                        TLDUtil.scanDTDAndXSD(file, (publicId, dtdFile) -> {
                            HashMap<String, Object> args = new HashMap<String, Object>();
                            args.put("location", dtdFile);
                            args.put("publicId", publicId);
                            antBuilder.invokeMethod("dtd", args);
                            if (logger.isInfoEnabled()) {
                                logger.info("DTD {}:{}", publicId, dtdFile);
                            }
                        }, (namespace, schemaFile) -> {
                            HashMap<String, Object> args = new HashMap<String, Object>();
                            args.put("file", schemaFile);
                            args.put("namespace", namespace);
                            antBuilder.invokeMethod("schema", args);
                            if (logger.isInfoEnabled()) {
                                logger.info("Schema {}:{}", namespace, schemaFile);
                            }
                        });
                    }
                    catch (Exception exception) {
                        if (!logger.isErrorEnabled()) continue;
                        String fileName = file.getName();
                        logger.error("Unable to process {}", (Object)fileName);
                    }
                }
            }
        };
        antBuilder.invokeMethod("schemavalidate", (Object)new Object[]{args, closure});
    }
}

