/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tlddoc.builder;

import com.liferay.gradle.plugins.tlddoc.builder.AppTLDDocBuilderExtension;
import com.liferay.gradle.plugins.tlddoc.builder.TLDDocBuilderPlugin;
import com.liferay.gradle.plugins.tlddoc.builder.tasks.TLDDocTask;
import com.liferay.gradle.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.bundling.Jar;

public class AppTLDDocBuilderPlugin
implements Plugin<Project> {
    public static final String APP_TLDDOC_TASK_NAME = "appTLDDoc";
    public static final String COPY_APP_TLDDOC_RESOURCES_TASK_NAME = "copyAppTLDDocResources";
    public static final String JAR_APP_TLDDOC_TASK_NAME = "jarAppTLDDoc";
    public static final String PLUGIN_NAME = "appTLDDocBuilder";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        final AppTLDDocBuilderExtension appTLDDocBuilderExtension = (AppTLDDocBuilderExtension)GradleUtil.addExtension((ExtensionAware)project, (String)PLUGIN_NAME, AppTLDDocBuilderExtension.class);
        Configuration tlddocConfiguration = TLDDocBuilderPlugin.addConfigurationTLDDoc(project);
        final Copy copyAppTLDDocResourcesTask = this._addTaskCopyAppTLDDocResources(project);
        final TLDDocTask appTLDDocTask = this._addTaskAppTLDDoc(copyAppTLDDocResourcesTask, (FileCollection)tlddocConfiguration);
        this._addTaskJarAppTLDDoc(appTLDDocTask);
        Gradle gradle = project.getGradle();
        gradle.afterProject((Closure)new Closure<Void>((Object)project){

            public void doCall(Project subproject) {
                Set<Project> subprojects = appTLDDocBuilderExtension.getSubprojects();
                PluginContainer pluginContainer = subproject.getPlugins();
                if (subprojects.contains(subproject) && pluginContainer.hasPlugin(TLDDocBuilderPlugin.class)) {
                    AppTLDDocBuilderPlugin.this._configureTaskAppTLDDoc(appTLDDocTask, subproject);
                    AppTLDDocBuilderPlugin.this._configureTaskCopyAppTLDDocResources(copyAppTLDDocResourcesTask, subproject);
                }
            }
        });
    }

    private TLDDocTask _addTaskAppTLDDoc(Copy copyAppTLDDocResourcesTask, FileCollection classpath) {
        final Project project = copyAppTLDDocResourcesTask.getProject();
        TLDDocTask tldDocTask = (TLDDocTask)GradleUtil.addTask((Project)project, (String)APP_TLDDOC_TASK_NAME, TLDDocTask.class);
        tldDocTask.dependsOn(new Object[]{copyAppTLDDocResourcesTask});
        tldDocTask.setClasspath(classpath);
        tldDocTask.setDescription("Generates tag library documentation for the app.");
        tldDocTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), "docs/tlddoc");
            }
        });
        tldDocTask.setGroup("documentation");
        return tldDocTask;
    }

    private Copy _addTaskCopyAppTLDDocResources(final Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)COPY_APP_TLDDOC_RESOURCES_TASK_NAME, Copy.class);
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                TLDDocTask appTLDDocTask = (TLDDocTask)GradleUtil.getTask((Project)project, (String)AppTLDDocBuilderPlugin.APP_TLDDOC_TASK_NAME);
                return appTLDDocTask.getDestinationDir();
            }
        });
        copy.setDescription("Copies tag library documentation resources.");
        return copy;
    }

    private Jar _addTaskJarAppTLDDoc(TLDDocTask tldDocTask) {
        Jar jar = (Jar)GradleUtil.addTask((Project)tldDocTask.getProject(), (String)JAR_APP_TLDDOC_TASK_NAME, Jar.class);
        jar.from(new Object[]{tldDocTask});
        jar.setClassifier("taglibdoc");
        jar.setDescription("Assembles a jar archive containing the tag library documentation files for this app.");
        jar.setGroup("build");
        return jar;
    }

    private void _configureTaskAppTLDDoc(TLDDocTask appTLDDocTask, Project subproject) {
        Task task = GradleUtil.getTask((Project)subproject, (String)"validateTLD");
        appTLDDocTask.dependsOn(new Object[]{task});
        TLDDocTask tldDocTask = (TLDDocTask)GradleUtil.getTask((Project)subproject, (String)"tlddoc");
        appTLDDocTask.source(tldDocTask.getSource());
    }

    private void _configureTaskCopyAppTLDDocResources(Copy copyAppTLDDocResourcesTask, Project subproject) {
        Copy copy = (Copy)GradleUtil.getTask((Project)subproject, (String)"copyTLDDocResources");
        TaskInputsInternal taskInputs = copy.getInputs();
        copyAppTLDDocResourcesTask.from(new Object[]{taskInputs.getFiles()});
    }
}

