/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration;

import com.liferay.gradle.plugins.test.integration.TestIntegrationBasePlugin;
import com.liferay.gradle.plugins.test.integration.TestIntegrationTomcatExtension;
import com.liferay.gradle.plugins.test.integration.tasks.BaseAppServerTask;
import com.liferay.gradle.plugins.test.integration.tasks.JmxRemotePortSpec;
import com.liferay.gradle.plugins.test.integration.tasks.ManagerSpec;
import com.liferay.gradle.plugins.test.integration.tasks.ModuleFrameworkBaseDirSpec;
import com.liferay.gradle.plugins.test.integration.tasks.SetUpArquillianTask;
import com.liferay.gradle.plugins.test.integration.tasks.SetUpTestableTomcatTask;
import com.liferay.gradle.plugins.test.integration.tasks.StartTestableTomcatTask;
import com.liferay.gradle.plugins.test.integration.tasks.StopTestableTomcatTask;
import com.liferay.gradle.plugins.test.integration.util.GradleUtil;
import com.liferay.gradle.plugins.test.integration.util.StringUtil;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.OSDetector;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.testing.Test;
import org.gradle.process.JavaForkOptions;

public class TestIntegrationPlugin
implements Plugin<Project> {
    public static final String PLUGIN_NAME = "testIntegration";
    public static final String SET_UP_ARQUILLIAN_TASK_NAME = "setUpArquillian";
    public static final String SET_UP_TESTABLE_TOMCAT_TASK_NAME = "setUpTestableTomcat";
    public static final String START_TESTABLE_TOMCAT_TASK_NAME = "startTestableTomcat";
    public static final String STOP_TESTABLE_TOMCAT_TASK_NAME = "stopTestableTomcat";
    private static final String _SKIP_MANAGED_APP_SERVER_FILE_NAME = "skip.managed.app.server";
    private static final Logger _logger = Logging.getLogger(TestIntegrationPlugin.class);
    private static final Set<File> _startedAppServerBinDirs = new HashSet<File>();
    private static final ReentrantLock _startedAppServersReentrantLock = new ReentrantLock();
    private static final Map<File, Integer> _startedAppServerStopCounters = new HashMap<File, Integer>();

    public void apply(final Project project) {
        GradleUtil.applyPlugin((Project)project, TestIntegrationBasePlugin.class);
        final SourceSet testIntegrationSourceSet = GradleUtil.getSourceSet((Project)project, (String)PLUGIN_NAME);
        final Test testIntegrationTask = (Test)GradleUtil.getTask((Project)project, (String)PLUGIN_NAME);
        final TestIntegrationTomcatExtension testIntegrationTomcatExtension = (TestIntegrationTomcatExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"testIntegrationTomcat", TestIntegrationTomcatExtension.class);
        SetUpTestableTomcatTask setUpTestableTomcatTask = this.addTaskSetUpTestableTomcat(project, testIntegrationTomcatExtension);
        StopTestableTomcatTask stopTestableTomcatTask = this.addTaskStopTestableTomcat(project, testIntegrationTask, testIntegrationTomcatExtension);
        StartTestableTomcatTask startTestableTomcatTask = this.addTaskStartTestableTomcat(project, setUpTestableTomcatTask, stopTestableTomcatTask, testIntegrationTomcatExtension);
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                SetUpArquillianTask setUpArquillianTask = TestIntegrationPlugin.this.addTaskSetUpArquillian(project, testIntegrationSourceSet, testIntegrationTomcatExtension);
                testIntegrationTask.dependsOn(new Object[]{setUpArquillianTask});
            }
        });
        this.configureTaskTestIntegration(testIntegrationTask, testIntegrationSourceSet, testIntegrationTomcatExtension, startTestableTomcatTask);
    }

    protected SetUpArquillianTask addTaskSetUpArquillian(Project project, final SourceSet testIntegrationSourceSet, TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        SetUpArquillianTask setUpArquillianTask = (SetUpArquillianTask)GradleUtil.addTask((Project)project, (String)SET_UP_ARQUILLIAN_TASK_NAME, SetUpArquillianTask.class);
        setUpArquillianTask.setDescription("Creates the Arquillian container configuration file for this project.");
        setUpArquillianTask.setOutputDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return TestIntegrationPlugin.this.getSrcDir(testIntegrationSourceSet.getResources());
            }
        });
        this.configureJmxRemotePortSpec(setUpArquillianTask, testIntegrationTomcatExtension);
        this.configureManagerSpec(setUpArquillianTask, testIntegrationTomcatExtension);
        return setUpArquillianTask;
    }

    protected SetUpTestableTomcatTask addTaskSetUpTestableTomcat(Project project, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        final SetUpTestableTomcatTask setUpTestableTomcatTask = (SetUpTestableTomcatTask)GradleUtil.addTask((Project)project, (String)SET_UP_TESTABLE_TOMCAT_TASK_NAME, SetUpTestableTomcatTask.class);
        setUpTestableTomcatTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                _startedAppServersReentrantLock.lock();
                try {
                    if (_startedAppServerBinDirs.contains(setUpTestableTomcatTask.getBinDir())) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
            }
        });
        setUpTestableTomcatTask.setDescription("Configures the local Liferay Tomcat bundle to run integration tests.");
        setUpTestableTomcatTask.setDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return testIntegrationTomcatExtension.getDir();
            }
        });
        this.configureJmxRemotePortSpec(setUpTestableTomcatTask, testIntegrationTomcatExtension);
        this.configureManagerSpec(setUpTestableTomcatTask, testIntegrationTomcatExtension);
        this.configureModuleFrameworkBaseDirSpec(setUpTestableTomcatTask, testIntegrationTomcatExtension);
        return setUpTestableTomcatTask;
    }

    protected StartTestableTomcatTask addTaskStartTestableTomcat(Project project, SetUpTestableTomcatTask setUpTestableTomcatTask, StopTestableTomcatTask stopTestableTomcatTask, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        StartTestableTomcatTask startTestableTomcatTask = (StartTestableTomcatTask)GradleUtil.addTask((Project)project, (String)START_TESTABLE_TOMCAT_TASK_NAME, StartTestableTomcatTask.class);
        startTestableTomcatTask.dependsOn(new Object[]{setUpTestableTomcatTask});
        Action<Task> action = new Action<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Task task) {
                StartTestableTomcatTask startTestableTomcatTask = (StartTestableTomcatTask)task;
                File binDir = startTestableTomcatTask.getBinDir();
                boolean started = false;
                _startedAppServersReentrantLock.lock();
                try {
                    if (_startedAppServerBinDirs.contains(binDir)) {
                        started = true;
                    } else {
                        _startedAppServerBinDirs.add(binDir);
                    }
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
                if (started) {
                    Project project;
                    Gradle gradle;
                    StartParameter startParameter;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Application server " + binDir + " is already started");
                    }
                    if ((startParameter = (gradle = (project = startTestableTomcatTask.getProject()).getGradle()).getStartParameter()).isParallelProjectExecutionEnabled()) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Waiting for application server " + binDir + " to be reachable");
                        }
                        startTestableTomcatTask.waitForReachable();
                    }
                    throw new StopExecutionException();
                }
            }
        };
        startTestableTomcatTask.doFirst((Action)action);
        startTestableTomcatTask.finalizedBy(new Object[]{stopTestableTomcatTask});
        startTestableTomcatTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                StartTestableTomcatTask startTestableTomcatTask = (StartTestableTomcatTask)task;
                return !startTestableTomcatTask.isReachable();
            }
        });
        startTestableTomcatTask.setDescription("Starts the local Liferay Tomcat bundle.");
        startTestableTomcatTask.setExecutable(this.getTomcatExecutableFileName("catalina"));
        startTestableTomcatTask.setExecutableArgs(Collections.singleton("run"));
        startTestableTomcatTask.setGroup("verification");
        startTestableTomcatTask.setLiferayHome(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return testIntegrationTomcatExtension.getLiferayHome();
            }
        });
        this.configureBaseAppServerTask(startTestableTomcatTask, testIntegrationTomcatExtension);
        return startTestableTomcatTask;
    }

    protected StopTestableTomcatTask addTaskStopTestableTomcat(Project project, Test testIntegrationTask, TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        final StopTestableTomcatTask stopTestableTomcatTask = (StopTestableTomcatTask)GradleUtil.addTask((Project)project, (String)STOP_TESTABLE_TOMCAT_TASK_NAME, StopTestableTomcatTask.class);
        Object action = new Action<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Task task) {
                StopTestableTomcatTask setUpTestableTomcatTask = (StopTestableTomcatTask)task;
                File binDir = setUpTestableTomcatTask.getBinDir();
                _startedAppServersReentrantLock.lock();
                try {
                    if (!_startedAppServerBinDirs.contains(binDir)) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Application server " + binDir + " is already stopped");
                        }
                        throw new StopExecutionException();
                    }
                    int originalCounter = TestIntegrationPlugin._updateStartedAppServerStopCounters(binDir, false);
                    if (originalCounter > 1) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Application server " + binDir + " cannot be stopped now, still " + (originalCounter - 1) + " to execute");
                        }
                        throw new StopExecutionException();
                    }
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
            }
        };
        stopTestableTomcatTask.doFirst((Action)action);
        action = new Action<Task>(){

            public void execute(Task task) {
                StopTestableTomcatTask setUpTestableTomcatTask = (StopTestableTomcatTask)task;
                _startedAppServersReentrantLock.lock();
                try {
                    _startedAppServerBinDirs.remove(setUpTestableTomcatTask.getBinDir());
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
            }
        };
        stopTestableTomcatTask.doLast((Action)action);
        stopTestableTomcatTask.mustRunAfter(new Object[]{testIntegrationTask});
        stopTestableTomcatTask.setDescription("Stops the local Liferay Tomcat bundle.");
        stopTestableTomcatTask.setExecutable(this.getTomcatExecutableFileName("shutdown"));
        stopTestableTomcatTask.setGroup("verification");
        this.configureBaseAppServerTask(stopTestableTomcatTask, testIntegrationTomcatExtension);
        this.configureModuleFrameworkBaseDirSpec(stopTestableTomcatTask, testIntegrationTomcatExtension);
        Gradle gradle = project.getGradle();
        TaskExecutionGraph taskExecutionGraph = gradle.getTaskGraph();
        Closure<Void> closure = new Closure<Void>((Object)gradle){

            public void doCall(TaskExecutionGraph taskExecutionGraph) {
                if (taskExecutionGraph.hasTask((Task)stopTestableTomcatTask)) {
                    _startedAppServersReentrantLock.lock();
                    try {
                        TestIntegrationPlugin._updateStartedAppServerStopCounters(stopTestableTomcatTask.getBinDir(), true);
                    }
                    finally {
                        _startedAppServersReentrantLock.unlock();
                    }
                }
            }
        };
        taskExecutionGraph.whenReady((Closure)closure);
        return stopTestableTomcatTask;
    }

    protected void configureBaseAppServerTask(BaseAppServerTask baseAppServerTask, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        baseAppServerTask.setBinDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(testIntegrationTomcatExtension.getDir(), "bin");
            }
        });
        baseAppServerTask.setCheckPath(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testIntegrationTomcatExtension.getCheckPath();
            }
        });
        baseAppServerTask.setPortNumber(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testIntegrationTomcatExtension.getPortNumber();
            }
        });
    }

    protected void configureJmxRemotePortSpec(JmxRemotePortSpec jmxRemotePortSpec, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        jmxRemotePortSpec.setJmxRemotePort(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testIntegrationTomcatExtension.getJmxRemotePort();
            }
        });
    }

    protected void configureManagerSpec(ManagerSpec managerSpec, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        managerSpec.setManagerPassword(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testIntegrationTomcatExtension.getManagerPassword();
            }
        });
        managerSpec.setManagerUserName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testIntegrationTomcatExtension.getManagerUserName();
            }
        });
    }

    protected void configureModuleFrameworkBaseDirSpec(ModuleFrameworkBaseDirSpec moduleFrameworkBaseDirSpec, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        moduleFrameworkBaseDirSpec.setModuleFrameworkBaseDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = testIntegrationTomcatExtension.getLiferayHome();
                if (dir != null) {
                    dir = new File(dir, "osgi");
                }
                return dir;
            }
        });
    }

    protected void configureTaskSystemProperty(JavaForkOptions javaForkOptions, String key, File file) {
        Map systemProperties = javaForkOptions.getSystemProperties();
        if (!systemProperties.containsKey(key)) {
            systemProperties.put(key, FileUtil.getAbsolutePath((File)file));
        }
    }

    protected void configureTaskTestIntegration(final Test test, final SourceSet testIntegrationSourceSet, final TestIntegrationTomcatExtension testIntegrationTomcatExtension, final StartTestableTomcatTask startTestableTomcatTask) {
        Closure<Task> closure = new Closure<Task>((Object)test.getProject()){

            public Task doCall(Test test) {
                SourceDirectorySet sourceDirectorySet = testIntegrationSourceSet.getResources();
                for (File dir : sourceDirectorySet.getSrcDirs()) {
                    File file = new File(dir, TestIntegrationPlugin._SKIP_MANAGED_APP_SERVER_FILE_NAME);
                    if (!file.exists()) continue;
                    return null;
                }
                return startTestableTomcatTask;
            }
        };
        test.dependsOn(new Object[]{closure});
        test.jvmArgs(new Object[]{"-Djava.net.preferIPv4Stack=true", "-Dliferay.mode=test", "-Duser.timezone=GMT"});
        Project project = test.getProject();
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                TestIntegrationPlugin.this.configureTaskTestIntegrationEnabled(test, testIntegrationSourceSet);
                TestIntegrationPlugin.this.configureTaskSystemProperty((JavaForkOptions)test, "app.server.tomcat.dir", testIntegrationTomcatExtension.getDir());
            }
        });
    }

    protected void configureTaskTestIntegrationEnabled(Test test, SourceSet testIntegrationSourceSet) {
        Project project = test.getProject();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("excludes", StringUtil.replaceEnding(test.getExcludes(), ".class", ".java"));
        args.put("includes", StringUtil.replaceEnding(test.getIncludes(), ".class", ".java"));
        SourceDirectorySet sourceDirectorySet = testIntegrationSourceSet.getJava();
        for (File dir : sourceDirectorySet.getSrcDirs()) {
            args.put("dir", dir);
            ConfigurableFileTree fileTree = project.fileTree(args);
            if (fileTree.isEmpty()) continue;
            return;
        }
        test.setDependsOn(Collections.emptySet());
        test.setEnabled(false);
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    protected String getTomcatExecutableFileName(String fileName) {
        if (OSDetector.isWindows()) {
            fileName = fileName + ".bat";
        }
        return fileName;
    }

    private static int _updateStartedAppServerStopCounters(File binDir, boolean increment) {
        int originalCounter = 0;
        if (_startedAppServerStopCounters.containsKey(binDir)) {
            originalCounter = _startedAppServerStopCounters.get(binDir);
        }
        int counter = originalCounter;
        counter = increment ? ++counter : --counter;
        _startedAppServerStopCounters.put(binDir, counter);
        return originalCounter;
    }
}

