/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration;

import com.liferay.gradle.plugins.test.integration.util.GradleUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;

public class TestIntegrationBasePlugin
implements Plugin<Project> {
    public static final String TEST_INTEGRATION_SOURCE_SET_NAME = "testIntegration";
    public static final String TEST_INTEGRATION_TASK_NAME = "testIntegration";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        SourceSet testIntegrationSourceSet = this.addSourceSetTestIntegration(project);
        Test testIntegrationTask = this.addTaskTestIntegration(project, testIntegrationSourceSet);
        this.configureEclipse(project, testIntegrationSourceSet);
        this.configureIdea(project, testIntegrationSourceSet);
        this.configureTaskCheck(testIntegrationTask);
    }

    protected SourceSet addSourceSetTestIntegration(Project project) {
        SourceSet testIntegrationSourceSet = GradleUtil.addSourceSet((Project)project, (String)"testIntegration");
        Configuration testIntegrationCompileConfiguration = GradleUtil.getConfiguration((Project)project, (String)testIntegrationSourceSet.getCompileConfigurationName());
        Configuration testCompileConfiguration = GradleUtil.getConfiguration((Project)project, (String)"testCompile");
        testIntegrationCompileConfiguration.extendsFrom(new Configuration[]{testCompileConfiguration});
        Configuration testIntegrationRuntimeConfiguration = GradleUtil.getConfiguration((Project)project, (String)testIntegrationSourceSet.getRuntimeConfigurationName());
        Configuration testRuntimeConfiguration = GradleUtil.getConfiguration((Project)project, (String)"testRuntime");
        testIntegrationRuntimeConfiguration.extendsFrom(new Configuration[]{testRuntimeConfiguration, testIntegrationCompileConfiguration});
        SourceSet mainSourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        FileCollection compileClasspath = testIntegrationSourceSet.getCompileClasspath();
        testIntegrationSourceSet.setCompileClasspath(compileClasspath.plus((FileCollection)mainSourceSet.getOutput()));
        FileCollection runtimeClasspath = testIntegrationSourceSet.getRuntimeClasspath();
        testIntegrationSourceSet.setRuntimeClasspath(runtimeClasspath.plus((FileCollection)mainSourceSet.getOutput()));
        return testIntegrationSourceSet;
    }

    protected Test addTaskTestIntegration(Project project, final SourceSet testIntegrationSourceSet) {
        final Test test = (Test)GradleUtil.addTask((Project)project, (String)"testIntegration", Test.class);
        test.mustRunAfter(new Object[]{"test"});
        test.setDescription("Runs the integration tests.");
        test.setForkEvery(null);
        test.setGroup("verification");
        ConventionMapping conventionMapping = test.getConventionMapping();
        conventionMapping.map("classpath", (Callable)new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                return testIntegrationSourceSet.getRuntimeClasspath();
            }
        });
        conventionMapping.map("testClassesDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSetOutput sourceSetOutput = testIntegrationSourceSet.getOutput();
                return sourceSetOutput.getClassesDir();
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Set includes = test.getIncludes();
                if (includes.isEmpty()) {
                    test.setIncludes(Collections.singleton("**/*Test.class"));
                }
            }
        });
        return test;
    }

    protected void configureEclipse(final Project project, final SourceSet testIntegrationSourceSet) {
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(EclipsePlugin.class, (Action)new Action<EclipsePlugin>(){

            public void execute(EclipsePlugin eclipsePlugin) {
                TestIntegrationBasePlugin.this.configureEclipseClasspath(project, testIntegrationSourceSet);
            }
        });
    }

    protected void configureEclipseClasspath(Project project, SourceSet testIntegrationSourceSet) {
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        Collection plusConfigurations = eclipseClasspath.getPlusConfigurations();
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)testIntegrationSourceSet.getRuntimeConfigurationName());
        plusConfigurations.add(configuration);
    }

    protected void configureIdea(final Project project, final SourceSet testIntegrationSourceSet) {
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(IdeaPlugin.class, (Action)new Action<IdeaPlugin>(){

            public void execute(IdeaPlugin ideaPlugin) {
                TestIntegrationBasePlugin.this.configureIdeaModule(project, testIntegrationSourceSet);
            }
        });
    }

    protected void configureIdeaModule(Project project, SourceSet testIntegrationSourceSet) {
        IdeaModel ideaModel = (IdeaModel)GradleUtil.getExtension((ExtensionAware)project, IdeaModel.class);
        IdeaModule ideaModule = ideaModel.getModule();
        Map scopes = ideaModule.getScopes();
        Map testScope = (Map)scopes.get("TEST");
        Collection plusConfigurations = (Collection)testScope.get("plus");
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)testIntegrationSourceSet.getRuntimeConfigurationName());
        plusConfigurations.add(configuration);
    }

    protected void configureTaskCheck(Test test) {
        Project project = test.getProject();
        Task task = GradleUtil.getTask((Project)project, (String)"check");
        task.dependsOn(new Object[]{test});
    }
}

