/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.patcher;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.ReplaceLeadingPathAction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.tools.ant.filters.FixCrLfFilter;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;

@CacheableTask
public class PatchTask
extends DefaultTask {
    public static final String PATCHED_SRC_DIR_MAPPING_DEFAULT_EXTENSION = "*";
    private static final String _BASE_URL = "https://repo.maven.apache.org/maven2/";
    private static final Map<String, Object> _fixCrLfArgs = new HashMap<String, Object>(){
        {
            this.put("eof", FixCrLfFilter.AddAsisRemove.newInstance((String)"remove"));
            this.put("eol", FixCrLfFilter.CrLf.newInstance((String)"lf"));
            this.put("fixlast", false);
        }
    };
    private final List<Object> _args = new ArrayList<Object>();
    private boolean _copyOriginalLibClasses = true;
    private final List<Object> _fileNames = new ArrayList<Object>();
    private Object _originalLibConfigurationName;
    private Object _originalLibFile;
    private Object _originalLibModuleName;
    private Object _originalLibSrcBaseUrl;
    private Object _originalLibSrcDirName = ".";
    private Object _originalLibSrcFile;
    private final Map<String, Object> _patchedSrcDirMappings = new HashMap<String, Object>();
    private Object _patchesDir = "patches";
    private final List<Object> _patchFiles = new ArrayList<Object>();

    public PatchTask() {
        this._originalLibConfigurationName = new Callable<String>(){

            @Override
            public String call() throws Exception {
                Project project = PatchTask.this.getProject();
                ConfigurationContainer configurationContainer = project.getConfigurations();
                Configuration configuration = (Configuration)configurationContainer.findByName("compileClasspath");
                if (configuration != null) {
                    return configuration.getName();
                }
                return "compile";
            }
        };
        this._originalLibFile = new Callable<File>(){

            @Override
            public File call() throws Exception {
                return PatchTask.this.getOriginalLibModuleFile();
            }
        };
        this._originalLibSrcFile = new Callable<File>(){

            @Override
            public File call() throws Exception {
                return FileUtil.get((Project)PatchTask.this.getProject(), (String)PatchTask.this.getOriginalLibSrcUrl());
            }
        };
        this.args("--no-backup-if-mismatch", "--strip=1");
    }

    public PatchTask args(Iterable<Object> args) {
        GUtil.addToCollection(this._args, args);
        return this;
    }

    public PatchTask args(Object ... args) {
        return this.args(Arrays.asList(args));
    }

    public PatchTask fileNames(Iterable<Object> fileNames) {
        GUtil.addToCollection(this._fileNames, fileNames);
        return this;
    }

    public PatchTask fileNames(Object ... fileNames) {
        return this.fileNames(Arrays.asList(fileNames));
    }

    public List<String> getArgs() {
        return GradleUtil.toStringList(this._args);
    }

    @Input
    public List<String> getFileNames() {
        return GradleUtil.toStringList(this._fileNames);
    }

    public String getOriginalLibConfigurationName() {
        return GradleUtil.toString((Object)this._originalLibConfigurationName);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getOriginalLibFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._originalLibFile);
    }

    public String getOriginalLibModuleGroup() {
        Dependency dependency = this.getOriginalLibDependency();
        return dependency.getGroup();
    }

    public String getOriginalLibModuleName() {
        return GradleUtil.toString((Object)this._originalLibModuleName);
    }

    public String getOriginalLibModuleVersion() {
        Dependency dependency = this.getOriginalLibDependency();
        return dependency.getVersion();
    }

    public String getOriginalLibSrcBaseUrl() {
        return GradleUtil.toString((Object)this._originalLibSrcBaseUrl);
    }

    @Input
    public String getOriginalLibSrcDirName() {
        return GradleUtil.toString((Object)this._originalLibSrcDirName);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getOriginalLibSrcFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._originalLibSrcFile);
    }

    public Map<String, File> getPatchedSrcDirMappings() {
        HashMap<String, File> patchedSrcDirMappings = new HashMap<String, File>();
        for (Map.Entry<String, Object> entry : this._patchedSrcDirMappings.entrySet()) {
            String extension = entry.getKey();
            File dir = GradleUtil.toFile((Project)this.getProject(), (Object)entry.getValue());
            patchedSrcDirMappings.put(extension, dir);
        }
        return patchedSrcDirMappings;
    }

    @OutputFiles
    public FileCollection getPatchedSrcFiles() {
        Project project = this.getProject();
        HashMap<File, ConfigurableFileTree> patchedSrcFileTreeMap = new HashMap<File, ConfigurableFileTree>();
        for (String fileName : this.getFileNames()) {
            File patchedDir = this.getPatchedSrcDir(fileName);
            ConfigurableFileTree configurableFileTree = (ConfigurableFileTree)patchedSrcFileTreeMap.get(patchedDir);
            if (configurableFileTree == null) {
                configurableFileTree = project.fileTree((Object)patchedDir);
                patchedSrcFileTreeMap.put(patchedDir, configurableFileTree);
            }
            configurableFileTree.include(new String[]{fileName});
        }
        Collection patchedSrcFileTrees = patchedSrcFileTreeMap.values();
        return project.files(patchedSrcFileTrees.toArray());
    }

    public File getPatchesDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._patchesDir);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public FileCollection getPatchFiles() {
        Project project = this.getProject();
        if (!this._patchFiles.isEmpty()) {
            return project.files(new Object[]{this._patchFiles});
        }
        return project.fileTree(this._patchesDir);
    }

    public boolean isCopyOriginalLibClasses() {
        return this._copyOriginalLibClasses;
    }

    @TaskAction
    public void patch() throws Exception {
        Project project = this.getProject();
        File patchesTemporaryDir = this.fixPatchFiles();
        final File srcTemporaryDir = this.fixSrcFiles();
        for (final File patchFile : this.getSortedFiles(patchesTemporaryDir)) {
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ExecResult execResult = project.exec((Action)new Action<ExecSpec>(){

                public void execute(ExecSpec execSpec) {
                    execSpec.args(PatchTask.this.getArgs());
                    if (OSDetector.isWindows()) {
                        execSpec.args(new Object[]{"--binary"});
                    }
                    String relativizePath = FileUtil.relativize((File)patchFile, (File)srcTemporaryDir);
                    execSpec.args(new Object[]{"--input=" + relativizePath});
                    execSpec.setExecutable("patch");
                    execSpec.setIgnoreExitValue(true);
                    execSpec.setStandardOutput((OutputStream)byteArrayOutputStream);
                    execSpec.setWorkingDir(srcTemporaryDir);
                }
            });
            System.out.println(byteArrayOutputStream.toString());
            execResult.rethrowFailure();
            execResult.assertNormalExitValue();
        }
        ConfigurableFileTree fileTree = project.fileTree((Object)srcTemporaryDir);
        for (File file : fileTree) {
            File patchedSrcDir = this.getPatchedSrcDir(file.getName());
            if (patchedSrcDir == null) continue;
            Path patchedSrcDirPath = patchedSrcDir.toPath();
            String relativePath = FileUtil.relativize((File)file, (File)srcTemporaryDir);
            patchedSrcDirPath = patchedSrcDirPath.resolve(relativePath);
            Files.createDirectories(patchedSrcDirPath.getParent(), new FileAttribute[0]);
            Files.move(file.toPath(), patchedSrcDirPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public PatchTask patchedSrcDirMapping(String extension, Object dir) {
        this._patchedSrcDirMappings.put(extension, dir);
        return this;
    }

    public PatchTask patchFiles(Iterable<Object> patchFiles) {
        GUtil.addToCollection(this._patchFiles, patchFiles);
        return this;
    }

    public PatchTask patchFiles(Object ... patchFiles) {
        return this.patchFiles(Arrays.asList(patchFiles));
    }

    public void setArgs(Iterable<Object> args) {
        this._args.clear();
        this.args(args);
    }

    public void setArgs(Object ... args) {
        this.setArgs(Arrays.asList(args));
    }

    public void setCopyOriginalLibClasses(boolean copyOriginalLibClasses) {
        this._copyOriginalLibClasses = copyOriginalLibClasses;
    }

    public void setFileNames(Iterable<Object> fileNames) {
        this._fileNames.clear();
        this.fileNames(fileNames);
    }

    public void setOriginalLibConfigurationName(Object originalLibConfigurationName) {
        this._originalLibConfigurationName = originalLibConfigurationName;
    }

    public void setOriginalLibFile(Object originalLibFile) {
        this._originalLibFile = originalLibFile;
    }

    public void setOriginalLibModuleName(Object originalLibModuleName) {
        this._originalLibModuleName = originalLibModuleName;
    }

    public void setOriginalLibSrcBaseUrl(Object originalLibSrcBaseUrl) {
        this._originalLibSrcBaseUrl = originalLibSrcBaseUrl;
    }

    public void setOriginalLibSrcDirName(Object originalLibSrcDirName) {
        this._originalLibSrcDirName = originalLibSrcDirName;
    }

    public void setOriginalLibSrcFile(Object originalLibSrcFile) {
        this._originalLibSrcFile = originalLibSrcFile;
    }

    public void setPatchedSrcDirMappings(Map<String, Object> patchedSrcDirMappings) {
        this._patchedSrcDirMappings.clear();
        this._patchedSrcDirMappings.putAll(patchedSrcDirMappings);
    }

    public void setPatchesDir(Object patchesDir) {
        this._patchesDir = patchesDir;
    }

    public void setPatchFiles(Iterable<Object> patchFiles) {
        this._patchFiles.clear();
        this.patchFiles(patchFiles);
    }

    protected File fixPatchFiles() {
        Project project = this.getProject();
        final File temporaryDir = new File(this.getTemporaryDir(), "patches");
        project.delete(new Object[]{temporaryDir});
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.filter(_fixCrLfArgs, FixCrLfFilter.class);
                copySpec.from(new Object[]{PatchTask.this.getPatchFiles()});
                copySpec.into((Object)temporaryDir);
                copySpec.setIncludeEmptyDirs(false);
            }
        });
        return temporaryDir;
    }

    protected File fixSrcFiles() {
        final Project project = this.getProject();
        final File temporaryDir = new File(this.getTemporaryDir(), "src");
        project.delete(new Object[]{temporaryDir});
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                String originalLibSrcDirName = PatchTask.this.getOriginalLibSrcDirName();
                if (!originalLibSrcDirName.equals(".")) {
                    HashMap<String, String> leadingPathReplacementsMap = new HashMap<String, String>();
                    leadingPathReplacementsMap.put(originalLibSrcDirName, "");
                    copySpec.eachFile((Action)new ReplaceLeadingPathAction(leadingPathReplacementsMap));
                }
                copySpec.filter(_fixCrLfArgs, FixCrLfFilter.class);
                copySpec.from(new Object[]{project.zipTree((Object)PatchTask.this.getOriginalLibSrcFile())});
                copySpec.include(PatchTask.this.getFileNames());
                copySpec.into((Object)temporaryDir);
                copySpec.setIncludeEmptyDirs(false);
            }
        });
        if (!temporaryDir.exists()) {
            try {
                Files.createDirectories(temporaryDir.toPath(), new FileAttribute[0]);
            }
            catch (IOException ioException) {
                throw new UncheckedIOException((Throwable)ioException);
            }
        }
        return temporaryDir;
    }

    protected Dependency getOriginalLibDependency() {
        Configuration configuration = GradleUtil.getConfiguration((Project)this.getProject(), (String)this.getOriginalLibConfigurationName());
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        String moduleName = this.getOriginalLibModuleName();
        for (Dependency dependency : resolvableDependencies.getDependencies()) {
            if (!moduleName.equals(dependency.getName())) continue;
            return dependency;
        }
        throw new GradleException("Unable to find original lib " + moduleName);
    }

    protected File getOriginalLibModuleFile() {
        String configurationName = this.getOriginalLibConfigurationName();
        String moduleGroup = this.getOriginalLibModuleGroup();
        String moduleName = this.getOriginalLibModuleName();
        String moduleVersion = this.getOriginalLibModuleVersion();
        if (Validator.isNull((String)configurationName) || Validator.isNull((String)moduleGroup) || Validator.isNull((String)moduleName) || Validator.isNull((String)moduleVersion)) {
            return null;
        }
        Configuration configuration = GradleUtil.getConfiguration((Project)this.getProject(), (String)configurationName);
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        for (ResolvedArtifact resolvedArtifact : resolvedConfiguration.getResolvedArtifacts()) {
            ResolvedModuleVersion resolvedModuleVersion = resolvedArtifact.getModuleVersion();
            ModuleVersionIdentifier moduleVersionIdentifier = resolvedModuleVersion.getId();
            if (!moduleGroup.equals(moduleVersionIdentifier.getGroup()) || !moduleName.equals(moduleVersionIdentifier.getName()) || !moduleVersion.equals(moduleVersionIdentifier.getVersion())) continue;
            return resolvedArtifact.getFile();
        }
        return null;
    }

    protected String getOriginalLibSrcUrl() {
        StringBuilder sb = new StringBuilder();
        String baseUrl = this.getOriginalLibSrcBaseUrl();
        if (Validator.isNotNull((String)baseUrl)) {
            sb.append(baseUrl);
            if (baseUrl.charAt(baseUrl.length() - 1) != '/') {
                sb.append('/');
            }
        } else {
            sb.append(_BASE_URL);
            String moduleGroup = this.getOriginalLibModuleGroup();
            sb.append(moduleGroup.replace('.', '/'));
            sb.append('/');
        }
        sb.append(this.getOriginalLibModuleName());
        sb.append('/');
        sb.append(this.getOriginalLibModuleVersion());
        sb.append('/');
        sb.append(this.getOriginalLibModuleName());
        sb.append('-');
        sb.append(this.getOriginalLibModuleVersion());
        sb.append("-sources.jar");
        return sb.toString();
    }

    protected File getPatchedSrcDir(String fileName) {
        Object patchedSrcDir;
        String extension = PATCHED_SRC_DIR_MAPPING_DEFAULT_EXTENSION;
        int pos = fileName.indexOf(46);
        if (pos != -1) {
            extension = fileName.substring(pos + 1);
        }
        if ((patchedSrcDir = this._patchedSrcDirMappings.get(extension)) == null) {
            patchedSrcDir = this._patchedSrcDirMappings.get(PATCHED_SRC_DIR_MAPPING_DEFAULT_EXTENSION);
        }
        return GradleUtil.toFile((Project)this.getProject(), (Object)patchedSrcDir);
    }

    protected List<File> getSortedFiles(File dir) {
        ArrayList<File> sortedFiles = new ArrayList<File>();
        Project project = this.getProject();
        ConfigurableFileTree fileTree = project.fileTree((Object)dir);
        GUtil.addToCollection(sortedFiles, (Iterable)fileTree);
        Collections.sort(sortedFiles);
        return sortedFiles;
    }
}

