/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.maven.plugin.builder.task;

import com.liferay.gradle.plugins.maven.plugin.builder.internal.util.GradleUtil;
import com.liferay.gradle.plugins.maven.plugin.builder.internal.util.XMLUtil;
import com.liferay.gradle.util.GUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;
import org.w3c.dom.Element;

@CacheableTask
public class BuildPluginDescriptorTask
extends DefaultTask {
    private Object _classesDir;
    private final Map<String, String> _configurationScopeMappings = new HashMap<String, String>();
    private final Set<String> _forcedExclusions = new HashSet<String>();
    private Object _goalPrefix;
    private boolean _mavenDebug;
    private FileCollection _mavenEmbedderClasspath;
    private Object _mavenEmbedderMainClassName = "org.apache.maven.cli.MavenCli";
    private Object _mavenPluginPluginVersion = "3.5.2";
    private Object _mavenSettingsFile;
    private Object _outputDir;
    private Object _pomArtifactId;
    private Object _pomGroupId;
    private final Map<String, Object> _pomRepositories = new LinkedHashMap<String, Object>();
    private Object _pomVersion;
    private Object _sourceDir;
    private boolean _useSetterComments = true;

    public BuildPluginDescriptorTask() {
        this._configurationScopeMappings.put("api", "compile");
        this._pomRepositories.put("liferay-public", "http://repository.liferay.com/nexus/content/groups/public");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TaskAction
    public void buildPluginDescriptor() {
        File pomFile;
        Project project;
        block6: {
            project = this.getProject();
            pomFile = project.file((Object)(System.currentTimeMillis() + ".xml"));
            File preparedSourceDir = null;
            try {
                if (this.isUseSetterComments()) {
                    preparedSourceDir = new File(this.getTemporaryDir(), "prepared-source");
                    this._prepareSources(preparedSourceDir);
                }
                this._buildPomFile(pomFile, preparedSourceDir);
                this._buildPluginDescriptor(pomFile);
                this._readdForcedExclusions();
                if (preparedSourceDir == null) break block6;
            }
            catch (Exception exception) {
                try {
                    throw new GradleException(exception.getMessage(), (Throwable)exception);
                }
                catch (Throwable throwable) {
                    if (preparedSourceDir != null) {
                        project.delete(new Object[]{preparedSourceDir});
                    }
                    project.delete(new Object[]{pomFile});
                    throw throwable;
                }
            }
            project.delete(new Object[]{preparedSourceDir});
        }
        project.delete(new Object[]{pomFile});
    }

    public void configurationScopeMapping(String configurationName, String scope) {
        this._configurationScopeMappings.put(configurationName, scope);
    }

    public BuildPluginDescriptorTask forcedExclusions(Iterable<String> forcedExclusions) {
        GUtil.addToCollection(this._forcedExclusions, forcedExclusions);
        return this;
    }

    public BuildPluginDescriptorTask forcedExclusions(String ... forcedExclusions) {
        return this.forcedExclusions(Arrays.asList(forcedExclusions));
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getClassesDir() {
        return GradleUtil.toFile(this.getProject(), this._classesDir);
    }

    @Input
    public Map<String, String> getConfigurationScopeMappings() {
        return this._configurationScopeMappings;
    }

    @Input
    public Set<String> getForcedExclusions() {
        return this._forcedExclusions;
    }

    @Input
    public String getGoalPrefix() {
        return GradleUtil.toString((Object)this._goalPrefix);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getMavenEmbedderClasspath() {
        return this._mavenEmbedderClasspath;
    }

    @Input
    public String getMavenEmbedderMainClassName() {
        return GradleUtil.toString((Object)this._mavenEmbedderMainClassName);
    }

    @Input
    public String getMavenPluginPluginVersion() {
        return GradleUtil.toString((Object)this._mavenPluginPluginVersion);
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getMavenSettingsFile() {
        return GradleUtil.toFile(this.getProject(), this._mavenSettingsFile);
    }

    @OutputDirectory
    public File getOutputDir() {
        return GradleUtil.toFile(this.getProject(), this._outputDir);
    }

    @Input
    public String getPomArtifactId() {
        return GradleUtil.toString((Object)this._pomArtifactId);
    }

    @Input
    public String getPomGroupId() {
        return GradleUtil.toString((Object)this._pomGroupId);
    }

    @Input
    public Map<String, Object> getPomRepositories() {
        return this._pomRepositories;
    }

    @Input
    public String getPomVersion() {
        return GradleUtil.toString((Object)this._pomVersion);
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getSourceDir() {
        return GradleUtil.toFile(this.getProject(), this._sourceDir);
    }

    @Input
    public boolean isMavenDebug() {
        return this._mavenDebug;
    }

    @Input
    public boolean isUseSetterComments() {
        return this._useSetterComments;
    }

    public BuildPluginDescriptorTask pomRepositories(Map<String, ?> pomRepositories) {
        this._pomRepositories.putAll(pomRepositories);
        return this;
    }

    public BuildPluginDescriptorTask pomRepository(String id, Object url) {
        this._pomRepositories.put(id, url);
        return this;
    }

    public void setClassesDir(Object classesDir) {
        this._classesDir = classesDir;
    }

    public void setForcedExclusions(Iterable<String> forcedExclusions) {
        this._forcedExclusions.clear();
        this.forcedExclusions(forcedExclusions);
    }

    public void setForcedExclusions(String ... forcedExclusions) {
        this.setForcedExclusions(Arrays.asList(forcedExclusions));
    }

    public void setGoalPrefix(Object goalPrefix) {
        this._goalPrefix = goalPrefix;
    }

    public void setMavenDebug(boolean mavenDebug) {
        this._mavenDebug = mavenDebug;
    }

    public void setMavenEmbedderClasspath(FileCollection mavenEmbedderClasspath) {
        this._mavenEmbedderClasspath = mavenEmbedderClasspath;
    }

    public void setMavenEmbedderMainClassName(Object mavenEmbedderMainClassName) {
        this._mavenEmbedderMainClassName = mavenEmbedderMainClassName;
    }

    public void setMavenPluginPluginVersion(Object mavenPluginPluginVersion) {
        this._mavenPluginPluginVersion = mavenPluginPluginVersion;
    }

    public void setMavenSettingsFile(Object mavenSettingsFile) {
        this._mavenSettingsFile = mavenSettingsFile;
    }

    public void setOutputDir(Object outputDir) {
        this._outputDir = outputDir;
    }

    public void setPomArtifactId(Object pomArtifactId) {
        this._pomArtifactId = pomArtifactId;
    }

    public void setPomGroupId(Object pomGroupId) {
        this._pomGroupId = pomGroupId;
    }

    public void setPomRepositories(Map<String, ?> pomRepositories) {
        this._pomRepositories.clear();
        this.pomRepositories(pomRepositories);
    }

    public void setPomVersion(Object pomVersion) {
        this._pomVersion = pomVersion;
    }

    public void setSourceDir(Object sourceDir) {
        this._sourceDir = sourceDir;
    }

    public void setUseSetterComments(boolean useSetterComments) {
        this._useSetterComments = useSetterComments;
    }

    private void _appendDependencyElements(org.w3c.dom.Document document, Element dependenciesElement, String configurationName, String scope) {
        Project project = this.getProject();
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration configuration = (Configuration)configurationContainer.findByName(configurationName);
        if (configuration == null) {
            return;
        }
        Logger logger = this.getLogger();
        Set<String> forcedExclusions = this.getForcedExclusions();
        Configuration resolvableConfiguration = GradleUtil.addConfiguration((Project)project, (String)("resolvable" + StringUtil.capitalize((String)configurationName)));
        resolvableConfiguration.extendsFrom(new Configuration[]{configuration});
        resolvableConfiguration.setVisible(false);
        ResolvedConfiguration resolvedConfiguration = resolvableConfiguration.getResolvedConfiguration();
        for (Dependency dependency : resolvableConfiguration.getAllDependencies()) {
            Element dependencyElement = document.createElement("dependency");
            dependenciesElement.appendChild(dependencyElement);
            final String dependencyGroup = dependency.getGroup();
            final String dependencyName = dependency.getName();
            String dependencyVersion = dependency.getVersion();
            Set resolvedDependencies = resolvedConfiguration.getFirstLevelModuleDependencies((Spec)new Spec<Dependency>(){

                public boolean isSatisfiedBy(Dependency dependency) {
                    return dependencyGroup.equals(dependency.getGroup()) && dependencyName.equals(dependency.getName());
                }
            });
            if (!resolvedDependencies.isEmpty()) {
                Iterator iterator = resolvedDependencies.iterator();
                ResolvedDependency resolvedDependency = (ResolvedDependency)iterator.next();
                dependencyVersion = resolvedDependency.getModuleVersion();
            } else if (logger.isWarnEnabled()) {
                logger.warn("Unable to find resolved module version for {}", (Object)dependency);
            }
            XMLUtil.appendElement(document, dependencyElement, "groupId", dependencyGroup);
            XMLUtil.appendElement(document, dependencyElement, "artifactId", this._getDependencyName(dependency));
            XMLUtil.appendElement(document, dependencyElement, "version", dependencyVersion);
            XMLUtil.appendElement(document, dependencyElement, "scope", scope);
            if (forcedExclusions.isEmpty()) continue;
            Element exclusionsElement = document.createElement("exclusions");
            dependencyElement.appendChild(exclusionsElement);
            for (String dependencyNotation : forcedExclusions) {
                this._appendDependencyExclusionElement(document, exclusionsElement, dependencyNotation);
            }
        }
    }

    private void _appendDependencyExclusionElement(org.w3c.dom.Document document, Element exclusionsElement, String dependencyNotation) {
        String[] tokens = this._parseDependencyNotation(dependencyNotation);
        String groupId = tokens[0];
        String artifactId = tokens[1];
        this._appendDependencyExclusionElement(document, exclusionsElement, groupId, artifactId);
    }

    private void _appendDependencyExclusionElement(org.w3c.dom.Document document, Element exclusionsElement, String groupId, String artifactId) {
        Element exclusionElement = document.createElement("exclusion");
        exclusionsElement.appendChild(exclusionElement);
        XMLUtil.appendElement(document, exclusionElement, "artifactId", artifactId);
        XMLUtil.appendElement(document, exclusionElement, "groupId", groupId);
    }

    private void _appendRepositoryElement(org.w3c.dom.Document document, Element repositoriesElement, String id, String url) {
        Element repositoryElement = document.createElement("repository");
        repositoriesElement.appendChild(repositoryElement);
        XMLUtil.appendElement(document, repositoryElement, "id", id);
        XMLUtil.appendElement(document, repositoryElement, "url", url);
    }

    private void _buildPluginDescriptor(final File pomFile) throws Exception {
        final Project project = this.getProject();
        project.javaexec((Action)new Action<JavaExecSpec>(){

            public void execute(JavaExecSpec javaExecSpec) {
                Property mainClass = javaExecSpec.getMainClass();
                mainClass.set((Object)BuildPluginDescriptorTask.this.getMavenEmbedderMainClassName());
                javaExecSpec.args(new Object[]{"--batch-mode", "--errors"});
                Logger logger = BuildPluginDescriptorTask.this.getLogger();
                if (logger.isInfoEnabled()) {
                    javaExecSpec.args(new Object[]{"--debug"});
                } else if (logger.isQuietEnabled()) {
                    javaExecSpec.args(new Object[]{"--quiet"});
                }
                javaExecSpec.args(new Object[]{"--file"});
                javaExecSpec.args(new Object[]{project.relativePath((Object)pomFile)});
                File mavenSettingsFile = BuildPluginDescriptorTask.this.getMavenSettingsFile();
                if (mavenSettingsFile != null) {
                    javaExecSpec.args(new Object[]{"--settings"});
                    javaExecSpec.args(new Object[]{project.relativePath((Object)mavenSettingsFile)});
                }
                javaExecSpec.args(new Object[]{"-Dencoding=UTF-8"});
                javaExecSpec.args(new Object[]{"plugin:descriptor"});
                javaExecSpec.setClasspath(BuildPluginDescriptorTask.this.getMavenEmbedderClasspath());
                javaExecSpec.setDebug(BuildPluginDescriptorTask.this.isMavenDebug());
                javaExecSpec.systemProperty("maven.multiModuleProjectDirectory", (Object)project.getProjectDir());
            }
        });
        File dir = new File(this.getClassesDir(), "META-INF/maven");
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                String fileName = String.valueOf(filePath.getFileName());
                if (fileName.endsWith(".xml")) {
                    try {
                        BuildPluginDescriptorTask.this._formatXML(filePath);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        File outputDir = this.getOutputDir();
        project.delete(new Object[]{outputDir});
        Files.move(dir.toPath(), outputDir.toPath(), new CopyOption[0]);
    }

    private void _buildPomFile(File pomFile, File sourceDir) throws Exception {
        Project project = this.getProject();
        if (sourceDir == null) {
            sourceDir = this.getSourceDir();
        }
        org.w3c.dom.Document document = XMLUtil.createDocument();
        Element projectElement = document.createElementNS("http://maven.apache.org/POM/4.0.0", "project");
        document.appendChild(projectElement);
        XMLUtil.appendElement(document, projectElement, "modelVersion", "4.0.0");
        XMLUtil.appendElement(document, projectElement, "groupId", this.getPomGroupId());
        XMLUtil.appendElement(document, projectElement, "artifactId", this.getPomArtifactId());
        XMLUtil.appendElement(document, projectElement, "version", this.getPomVersion());
        XMLUtil.appendElement(document, projectElement, "packaging", "maven-plugin");
        Element buildElement = document.createElement("build");
        projectElement.appendChild(buildElement);
        XMLUtil.appendElement(document, buildElement, "outputDirectory", project.relativePath((Object)this.getClassesDir()));
        XMLUtil.appendElement(document, buildElement, "sourceDirectory", project.relativePath((Object)sourceDir));
        Element pluginsElement = document.createElement("plugins");
        buildElement.appendChild(pluginsElement);
        Element pluginElement = document.createElement("plugin");
        pluginsElement.appendChild(pluginElement);
        XMLUtil.appendElement(document, pluginElement, "groupId", "org.apache.maven.plugins");
        XMLUtil.appendElement(document, pluginElement, "artifactId", "maven-plugin-plugin");
        XMLUtil.appendElement(document, pluginElement, "version", this.getMavenPluginPluginVersion());
        String goalPrefix = this.getGoalPrefix();
        if (Validator.isNotNull((String)goalPrefix)) {
            Element configurationElement = document.createElement("configuration");
            pluginElement.appendChild(configurationElement);
            XMLUtil.appendElement(document, configurationElement, "goalPrefix", goalPrefix);
        }
        Element dependenciesElement = document.createElement("dependencies");
        projectElement.appendChild(dependenciesElement);
        Map<String, String> pomConfigurationScopeMappings = this.getConfigurationScopeMappings();
        for (Map.Entry<String, String> entry : pomConfigurationScopeMappings.entrySet()) {
            String configurationName = entry.getKey();
            String scope = entry.getValue();
            this._appendDependencyElements(document, dependenciesElement, configurationName, scope);
        }
        Map<String, Object> pomRepositories = this.getPomRepositories();
        if (!pomRepositories.isEmpty()) {
            Element repositoriesElement = document.createElement("repositories");
            projectElement.appendChild(repositoriesElement);
            for (Map.Entry<String, Object> entry : pomRepositories.entrySet()) {
                String id = entry.getKey();
                String url = GradleUtil.toString((Object)entry.getValue());
                this._appendRepositoryElement(document, repositoriesElement, id, url);
            }
        }
        XMLUtil.write(document, pomFile);
    }

    private void _formatXML(Path filePath) throws Exception {
        String content = new String(Files.readAllBytes(filePath), StandardCharsets.UTF_8);
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((Reader)new StringReader(content));
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setExpandEmptyElements(false);
        outputFormat.setIndent("\t");
        outputFormat.setLineSeparator("\n");
        outputFormat.setTrimText(true);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, outputFormat);
        xmlWriter.write(document);
        content = stringWriter.toString();
        content = content.trim();
        while (content.contains(" \n")) {
            content = content.replace(" \n", "\n");
        }
        content = content.replace("-->\n<", "-->\n\n<");
        content = content.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<?xml version=\"1.0\"?>");
        Files.write(filePath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private String _getComments(JavaMethod javaMethod) {
        String code = javaMethod.getCodeBlock();
        int start = code.indexOf("/**");
        if (start < 0) {
            throw new GradleException("Unable to find comments start " + code);
        }
        int end = code.indexOf("*/", start);
        if (end < 0) {
            throw new GradleException("Unable to find comments end " + code);
        }
        return code.substring(start, end + 2);
    }

    private String _getDependencyName(Dependency dependency) {
        block3: {
            if (dependency instanceof ProjectDependency) {
                ProjectDependency projectDependency = (ProjectDependency)dependency;
                Project dependencyProject = projectDependency.getDependencyProject();
                try {
                    return GradleUtil.getArchivesBaseName(dependencyProject);
                }
                catch (IllegalStateException illegalStateException) {
                    Logger logger = this.getLogger();
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("Unable to find name for " + dependency, (Throwable)illegalStateException);
                }
            }
        }
        return dependency.getName();
    }

    private String _getTypeName(Type type) {
        String name = type.getFullyQualifiedName();
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        return name;
    }

    private String[] _parseDependencyNotation(String dependencyNotation) {
        String[] tokens = dependencyNotation.split(":");
        if (tokens.length != 3) {
            throw new GradleException("Unable to parse dependency notation " + dependencyNotation);
        }
        return tokens;
    }

    private void _prepareSource(JavaClass javaClass) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (BeanProperty beanProperty : javaClass.getBeanProperties()) {
            JavaMethod javaMethod = beanProperty.getMutator();
            DocletTag parameterDocletTag = javaMethod.getTagByName("parameter");
            if (parameterDocletTag == null) continue;
            sb.append(this._getComments(javaMethod));
            sb.append('\n');
            sb.append("private ");
            sb.append(this._getTypeName(beanProperty.getType()));
            sb.append(' ');
            sb.append(beanProperty.getName());
            sb.append(';');
            sb.append('\n');
        }
        if (sb.length() == 0) {
            return;
        }
        JavaSource javaSource = javaClass.getSource();
        URL url = javaSource.getURL();
        Path path = Paths.get(url.toURI());
        String code = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        int pos = code.lastIndexOf(125);
        code = code.substring(0, pos) + sb.toString() + code.substring(pos);
        Files.write(path, code.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void _prepareSources(final File preparedSourceDir) throws Exception {
        Project project = this.getProject();
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from(new Object[]{BuildPluginDescriptorTask.this.getSourceDir()});
                copySpec.include(new String[]{"**/*Mojo.java"});
                copySpec.into((Object)preparedSourceDir);
            }
        });
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder();
        javaDocBuilder.addSourceTree(preparedSourceDir);
        for (JavaClass javaClass : javaDocBuilder.getClasses()) {
            this._prepareSource(javaClass);
        }
    }

    private void _readdForcedExclusions() throws Exception {
        Set<String> forcedExclusions = this.getForcedExclusions();
        if (forcedExclusions.isEmpty()) {
            return;
        }
        File file = new File(this.getOutputDir(), "plugin.xml");
        Path path = file.toPath();
        String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        int pos = content.lastIndexOf("</dependencies>");
        if (pos == -1) {
            Logger logger = this.getLogger();
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to readd forced exclusions");
            }
            return;
        }
        String indent = "\t";
        while (content.charAt(--pos) == '\t') {
            indent = indent + "\t";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(content, 0, pos);
        for (String dependencyNotation : forcedExclusions) {
            String[] tokens = this._parseDependencyNotation(dependencyNotation);
            String groupId = tokens[0];
            String artifactId = tokens[1];
            String version = tokens[2];
            sb.append("\n");
            sb.append(indent);
            sb.append("<dependency>\n");
            sb.append(indent);
            sb.append("\t<groupId>");
            sb.append(groupId);
            sb.append("</groupId>\n");
            sb.append(indent);
            sb.append("\t<artifactId>");
            sb.append(artifactId);
            sb.append("</artifactId>\n");
            sb.append(indent);
            sb.append("\t<type>jar</type>\n");
            sb.append(indent);
            sb.append("\t<version>");
            sb.append(version);
            sb.append("</version>\n");
            sb.append(indent);
            sb.append("</dependency>");
        }
        sb.append(content, pos, content.length());
        content = sb.toString();
        Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

