/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.maven.plugin.builder;

import com.liferay.gradle.plugins.maven.plugin.builder.internal.util.GradleUtil;
import com.liferay.gradle.plugins.maven.plugin.builder.tasks.BuildPluginDescriptorTask;
import com.liferay.gradle.plugins.maven.plugin.builder.tasks.WriteMavenSettingsTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.CoreJavadocOptions;

public class MavenPluginBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_PLUGIN_DESCRIPTOR_TASK_NAME = "buildPluginDescriptor";
    public static final String MAVEN_EMBEDDER_CONFIGURATION_NAME = "mavenEmbedder";
    public static final String WRITE_MAVEN_SETTINGS_TASK = "writeMavenSettings";
    private static final OsgiHelper _osgiHelper = new OsgiHelper();

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        Configuration mavenEmbedderConfiguration = this._addConfigurationMavenEmbedder(project);
        WriteMavenSettingsTask writeMavenSettingsTask = this._addTaskWriteMavenSettings(project);
        BuildPluginDescriptorTask buildPluginDescriptorTask = this._addTaskBuildPluginDescriptor(writeMavenSettingsTask, (FileCollection)mavenEmbedderConfiguration);
        JavaVersion javaVersion = JavaVersion.current();
        if (javaVersion.isJava8Compatible()) {
            this._configureTasksJavadocDisableDoclint(project);
        }
        this._configureTasksBuildPluginDescriptor(project);
        this._configureTasksUpload(project, buildPluginDescriptorTask);
    }

    private Configuration _addConfigurationMavenEmbedder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                MavenPluginBuilderPlugin.this._addDependenciesMavenEmbedder(project);
            }
        });
        configuration.setDescription("Configures Maven Embedder for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesMavenEmbedder(Project project) {
        GradleUtil.addDependency((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME, (String)"org.apache.maven", (String)"maven-embedder", (String)"3.3.9");
        GradleUtil.addDependency((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME, (String)"org.apache.maven.wagon", (String)"wagon-http", (String)"2.10");
        GradleUtil.addDependency((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME, (String)"org.eclipse.aether", (String)"aether-connector-basic", (String)"1.0.2.v20150114");
        GradleUtil.addDependency((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME, (String)"org.eclipse.aether", (String)"aether-transport-wagon", (String)"1.0.2.v20150114");
        GradleUtil.addDependency((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME, (String)"org.slf4j", (String)"slf4j-simple", (String)"1.7.5");
    }

    private BuildPluginDescriptorTask _addTaskBuildPluginDescriptor(final WriteMavenSettingsTask writeMavenSettingsTask, FileCollection mavenEmbedderClasspath) {
        final Project project = writeMavenSettingsTask.getProject();
        BuildPluginDescriptorTask buildPluginDescriptorTask = (BuildPluginDescriptorTask)GradleUtil.addTask((Project)project, (String)BUILD_PLUGIN_DESCRIPTOR_TASK_NAME, BuildPluginDescriptorTask.class);
        buildPluginDescriptorTask.dependsOn(new Object[]{"compileJava", writeMavenSettingsTask});
        final SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        buildPluginDescriptorTask.setClassesDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return FileUtil.getJavaClassesDir((SourceSet)sourceSet);
            }
        });
        buildPluginDescriptorTask.setDescription("Generates the Maven plugin descriptor for the project.");
        buildPluginDescriptorTask.setGroup("build");
        buildPluginDescriptorTask.setMavenEmbedderClasspath(mavenEmbedderClasspath);
        buildPluginDescriptorTask.setMavenSettingsFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return writeMavenSettingsTask.getOutputFile();
            }
        });
        buildPluginDescriptorTask.setOutputDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = MavenPluginBuilderPlugin.this._getSrcDir(sourceSet.getResources());
                return new File(resourcesDir, "META-INF/maven");
            }
        });
        buildPluginDescriptorTask.setPomArtifactId(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return _osgiHelper.getBundleSymbolicName(project);
            }
        });
        buildPluginDescriptorTask.setPomGroupId(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getGroup();
            }
        });
        buildPluginDescriptorTask.setPomVersion(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String version = String.valueOf(project.getVersion());
                if (version.endsWith("-SNAPSHOT")) {
                    version = version.substring(0, version.length() - 9);
                }
                return version;
            }
        });
        buildPluginDescriptorTask.setSourceDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return MavenPluginBuilderPlugin.this._getSrcDir(sourceSet.getJava());
            }
        });
        Task processResourcesTask = GradleUtil.getTask((Project)project, (String)"processResources");
        processResourcesTask.mustRunAfter(new Object[]{buildPluginDescriptorTask});
        return buildPluginDescriptorTask;
    }

    private WriteMavenSettingsTask _addTaskWriteMavenSettings(final Project project) {
        WriteMavenSettingsTask writeMavenSettingsTask = (WriteMavenSettingsTask)GradleUtil.addTask((Project)project, (String)WRITE_MAVEN_SETTINGS_TASK, WriteMavenSettingsTask.class);
        writeMavenSettingsTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                WriteMavenSettingsTask writeMavenSettingsTask = (WriteMavenSettingsTask)task;
                Logger logger = writeMavenSettingsTask.getLogger();
                if (!logger.isLifecycleEnabled()) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Using ");
                String repositoryUrl = writeMavenSettingsTask.getRepositoryUrl();
                if (Validator.isNotNull((String)repositoryUrl)) {
                    sb.append(repositoryUrl);
                    sb.append(" as");
                } else {
                    sb.append("no");
                }
                sb.append(" custom repository and ");
                String proxyHost = writeMavenSettingsTask.getProxyHost();
                Integer proxyPort = writeMavenSettingsTask.getProxyPort();
                if (Validator.isNotNull((String)proxyHost) && proxyPort != null) {
                    sb.append(proxyHost);
                    sb.append(':');
                    sb.append(proxyPort);
                    sb.append(" as");
                } else {
                    sb.append("no");
                }
                sb.append(" proxy for Maven invocations in ");
                sb.append(writeMavenSettingsTask.getProject());
                sb.append('.');
                logger.lifecycle(sb.toString());
            }
        });
        writeMavenSettingsTask.setDescription("Writes a temporary Maven settings file to be used during subsequent Maven invocations.");
        writeMavenSettingsTask.setLocalRepositoryDir(new SystemPropertyCallable("maven.repo.local"));
        writeMavenSettingsTask.setNonProxyHosts(System.getProperty("http.nonProxyHosts"));
        writeMavenSettingsTask.setProxyHost(new ProxyPropertyCallable("proxyHost", writeMavenSettingsTask));
        writeMavenSettingsTask.setProxyPassword(new ProxyPropertyCallable("proxyPassword", writeMavenSettingsTask));
        writeMavenSettingsTask.setProxyPort(new ProxyPropertyCallable("proxyPort", writeMavenSettingsTask));
        writeMavenSettingsTask.setProxyUser(new ProxyPropertyCallable("proxyUser", writeMavenSettingsTask));
        writeMavenSettingsTask.setRepositoryUrl(System.getProperty("repository.url"));
        writeMavenSettingsTask.setOutputFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), "settings.xml");
            }
        });
        return writeMavenSettingsTask;
    }

    private void _configureTaskBuildPluginDescriptor(BuildPluginDescriptorTask buildPluginDescriptorTask) {
        boolean mavenDebug = Boolean.parseBoolean(GradleUtil.getTaskPrefixedProperty((Task)buildPluginDescriptorTask, (String)"maven.debug"));
        buildPluginDescriptorTask.setMavenDebug(mavenDebug);
    }

    private void _configureTaskJavadocDisableDoclint(Javadoc javadoc) {
        CoreJavadocOptions coreJavadocOptions = (CoreJavadocOptions)javadoc.getOptions();
        coreJavadocOptions.addStringOption("Xdoclint:none", "-quiet");
    }

    private void _configureTasksBuildPluginDescriptor(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildPluginDescriptorTask.class, (Action)new Action<BuildPluginDescriptorTask>(){

            public void execute(BuildPluginDescriptorTask buildPluginDescriptorTask) {
                MavenPluginBuilderPlugin.this._configureTaskBuildPluginDescriptor(buildPluginDescriptorTask);
            }
        });
    }

    private void _configureTasksJavadocDisableDoclint(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Javadoc.class, (Action)new Action<Javadoc>(){

            public void execute(Javadoc javadoc) {
                MavenPluginBuilderPlugin.this._configureTaskJavadocDisableDoclint(javadoc);
            }
        });
    }

    private void _configureTasksUpload(Project project, final BuildPluginDescriptorTask buildPluginDescriptorTask) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Upload.class, (Action)new Action<Upload>(){

            public void execute(Upload upload) {
                MavenPluginBuilderPlugin.this._configureTaskUpload(upload, buildPluginDescriptorTask);
            }
        });
    }

    private void _configureTaskUpload(Upload upload, BuildPluginDescriptorTask buildPluginDescriptorTask) {
        upload.dependsOn(new Object[]{buildPluginDescriptorTask});
    }

    private File _getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    private static class SystemPropertyCallable
    implements Callable<String> {
        private final String _key;

        public SystemPropertyCallable(String key) {
            this._key = key;
        }

        @Override
        public String call() throws Exception {
            return System.getProperty(this.getSystemPropertyKey());
        }

        protected String getSystemPropertyKey() {
            return this._key;
        }
    }

    private static class ProxyPropertyCallable
    extends SystemPropertyCallable {
        private final WriteMavenSettingsTask _writeMavenSettingsTask;

        public ProxyPropertyCallable(String key, WriteMavenSettingsTask writeMavenSettingsTask) {
            super(key);
            this._writeMavenSettingsTask = writeMavenSettingsTask;
        }

        @Override
        protected String getSystemPropertyKey() {
            String protocol = "https";
            String repositoryUrl = this._writeMavenSettingsTask.getRepositoryUrl();
            if (Validator.isNotNull((String)repositoryUrl)) {
                protocol = repositoryUrl.substring(0, repositoryUrl.indexOf(58));
            }
            return protocol + "." + super.getSystemPropertyKey();
        }
    }
}

