/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.maven.plugin.builder.tasks;

import com.liferay.gradle.plugins.maven.plugin.builder.internal.util.XMLUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WriteMavenSettingsTask
extends DefaultTask {
    private Object _nonProxyHosts;
    private Object _outputFile;
    private Object _proxyHost;
    private Object _proxyPassword;
    private Object _proxyPort;
    private Object _proxyUser;
    private Object _repositoryUrl;

    @Input
    @Optional
    public String getNonProxyHosts() {
        return GradleUtil.toString((Object)this._nonProxyHosts);
    }

    @OutputFile
    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    @Input
    @Optional
    public String getProxyHost() {
        return GradleUtil.toString((Object)this._proxyHost);
    }

    @Input
    @Optional
    public String getProxyPassword() {
        return GradleUtil.toString((Object)this._proxyPassword);
    }

    @Input
    @Optional
    public Integer getProxyPort() {
        return GradleUtil.toInteger((Object)this._proxyPort);
    }

    @Input
    @Optional
    public String getProxyUser() {
        return GradleUtil.toString((Object)this._proxyUser);
    }

    @Input
    @Optional
    public String getRepositoryUrl() {
        return GradleUtil.toString((Object)this._repositoryUrl);
    }

    public void setNonProxyHosts(Object nonProxyHosts) {
        this._nonProxyHosts = nonProxyHosts;
    }

    public void setOutputFile(Object outputFile) {
        this._outputFile = outputFile;
    }

    public void setProxyHost(Object proxyHost) {
        this._proxyHost = proxyHost;
    }

    public void setProxyPassword(Object proxyPassword) {
        this._proxyPassword = proxyPassword;
    }

    public void setProxyPort(Object proxyPort) {
        this._proxyPort = proxyPort;
    }

    public void setProxyUser(Object proxyUser) {
        this._proxyUser = proxyUser;
    }

    public void setRepositoryUrl(Object repositoryUrl) {
        this._repositoryUrl = repositoryUrl;
    }

    @TaskAction
    public void writeMavenSettingsFile() throws Exception {
        Document document = XMLUtil.createDocument();
        Element settingsElement = document.createElementNS("http://maven.apache.org/SETTINGS/1.0.0", "settings");
        document.appendChild(settingsElement);
        String repositoryUrl = this.getRepositoryUrl();
        if (Validator.isNotNull((String)repositoryUrl)) {
            Element mirrorsElement = document.createElement("mirrors");
            settingsElement.appendChild(mirrorsElement);
            Element mirrorElement = document.createElement("mirror");
            mirrorsElement.appendChild(mirrorElement);
            XMLUtil.appendElement(document, mirrorElement, "mirrorOf", "*");
            XMLUtil.appendElement(document, mirrorElement, "url", repositoryUrl);
        }
        String proxyHost = this.getProxyHost();
        Integer proxyPort = this.getProxyPort();
        if (Validator.isNotNull((String)proxyHost) && proxyPort != null) {
            Element proxiesElement = document.createElement("proxies");
            settingsElement.appendChild(proxiesElement);
            Element proxyElement = document.createElement("proxy");
            proxiesElement.appendChild(proxyElement);
            XMLUtil.appendElement(document, proxyElement, "host", proxyHost);
            XMLUtil.appendElement(document, proxyElement, "port", proxyPort.toString());
            WriteMavenSettingsTask._appendNonNullElement(document, proxyElement, "username", this.getProxyUser());
            WriteMavenSettingsTask._appendNonNullElement(document, proxyElement, "password", this.getProxyPassword());
            WriteMavenSettingsTask._appendNonNullElement(document, proxyElement, "nonProxyHosts", this.getNonProxyHosts());
        }
        XMLUtil.write(document, this.getOutputFile());
    }

    private static void _appendNonNullElement(Document document, Element parentElement, String name, String text) {
        if (Validator.isNull((String)text)) {
            return;
        }
        XMLUtil.appendElement(document, parentElement, name, text);
    }
}

