/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.maven.plugin.builder;

import com.liferay.gradle.plugins.maven.plugin.builder.BuildPluginDescriptorTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.Upload;

public class MavenPluginBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_PLUGIN_DESCRIPTOR_TASK_NAME = "buildPluginDescriptor";
    private static final OsgiHelper _osgiHelper = new OsgiHelper();

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        BuildPluginDescriptorTask buildPluginDescriptorTask = this.addTaskBuildPluginDescriptor(project);
        this.configureTasksUpload(project, buildPluginDescriptorTask);
    }

    protected BuildPluginDescriptorTask addTaskBuildPluginDescriptor(final Project project) {
        BuildPluginDescriptorTask buildPluginDescriptorTask = (BuildPluginDescriptorTask)GradleUtil.addTask((Project)project, (String)BUILD_PLUGIN_DESCRIPTOR_TASK_NAME, BuildPluginDescriptorTask.class);
        buildPluginDescriptorTask.dependsOn(new Object[]{"compileJava"});
        final SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        buildPluginDescriptorTask.setClassesDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return sourceSetOutput.getClassesDir();
            }
        });
        buildPluginDescriptorTask.setDescription("Generates the Maven plugin descriptor for the project.");
        buildPluginDescriptorTask.setGroup("build");
        buildPluginDescriptorTask.setOutputDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = MavenPluginBuilderPlugin.this.getSrcDir(sourceSet.getResources());
                return new File(resourcesDir, "META-INF/maven");
            }
        });
        buildPluginDescriptorTask.setPomArtifactId(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return _osgiHelper.getBundleSymbolicName(project);
            }
        });
        buildPluginDescriptorTask.setPomGroupId(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getGroup();
            }
        });
        buildPluginDescriptorTask.setPomVersion(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getVersion();
            }
        });
        buildPluginDescriptorTask.setSourceDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return MavenPluginBuilderPlugin.this.getSrcDir(sourceSet.getJava());
            }
        });
        Task processResourcesTask = GradleUtil.getTask((Project)project, (String)"processResources");
        processResourcesTask.mustRunAfter(new Object[]{buildPluginDescriptorTask});
        return buildPluginDescriptorTask;
    }

    protected void configureTasksUpload(Project project, final BuildPluginDescriptorTask buildPluginDescriptorTask) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Upload.class, (Action)new Action<Upload>(){

            public void execute(Upload upload) {
                MavenPluginBuilderPlugin.this.configureTaskUpload(upload, buildPluginDescriptorTask);
            }
        });
    }

    protected void configureTaskUpload(Upload upload, BuildPluginDescriptorTask buildPluginDescriptorTask) {
        upload.dependsOn(new Object[]{buildPluginDescriptorTask});
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

