/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.js.transpiler;

import com.liferay.gradle.plugins.js.transpiler.TranspileJSTask;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeModuleTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.copy.RenameDependencyClosure;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;

public class JSTranspilerPlugin
implements Plugin<Project> {
    public static final String DOWNLOAD_METAL_CLI_TASK_NAME = "downloadMetalCli";
    public static final String JS_COMPILE_CONFIGURATION_NAME = "jsCompile";
    public static final String SOY_COMPILE_CONFIGURATION_NAME = "soyCompile";
    public static final String TRANSPILE_JS_TASK_NAME = "transpileJS";
    private static final String _METAL_CLI_VERSION = "1.3.1";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        final NpmInstallTask npmInstallTask = (NpmInstallTask)GradleUtil.getTask((Project)project, (String)"npmInstall");
        final DownloadNodeModuleTask downloadMetalCliTask = this._addTaskDownloadMetalCli(project);
        final Configuration jsCompileConfiguration = this._addConfigurationJSCompile(project);
        final Configuration soyCompileConfiguration = this._addConfigurationSoyCompile(project);
        final TranspileJSTask transpileJSTask = this._addTaskTranspileJS(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                JSTranspilerPlugin.this._addTasksExpandJSCompileDependencies(transpileJSTask, npmInstallTask, jsCompileConfiguration);
                JSTranspilerPlugin.this._addTasksExpandSoyCompileDependencies(transpileJSTask, soyCompileConfiguration);
                JSTranspilerPlugin.this._configureTasksTranspileJS(project, downloadMetalCliTask, (ExecuteNpmTask)npmInstallTask);
            }
        });
    }

    private Configuration _addConfigurationJSCompile(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)JS_COMPILE_CONFIGURATION_NAME);
        configuration.setDescription("Configures additional JavaScript dependencies.");
        configuration.setVisible(false);
        return configuration;
    }

    private Configuration _addConfigurationSoyCompile(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)SOY_COMPILE_CONFIGURATION_NAME);
        configuration.setDescription("Configures additional Soy dependencies.");
        configuration.setVisible(false);
        return configuration;
    }

    private DownloadNodeModuleTask _addTaskDownloadMetalCli(Project project) {
        DownloadNodeModuleTask downloadNodeModuleTask = (DownloadNodeModuleTask)GradleUtil.addTask((Project)project, (String)DOWNLOAD_METAL_CLI_TASK_NAME, DownloadNodeModuleTask.class);
        downloadNodeModuleTask.setModuleName((Object)"metal-cli");
        downloadNodeModuleTask.setModuleVersion((Object)_METAL_CLI_VERSION);
        return downloadNodeModuleTask;
    }

    private Copy _addTaskExpandCompileDependency(Project project, File file, File destinationDir, String taskNamePrefix, RenameDependencyClosure renameDependencyClosure) {
        String taskName = GradleUtil.getTaskName((String)taskNamePrefix, (File)file);
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)taskName, Copy.class);
        copy.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                Project project = copy.getProject();
                project.delete(new Object[]{copy.getDestinationDir()});
            }
        });
        copy.from(new Object[]{project.zipTree((Object)file)});
        String name = (String)renameDependencyClosure.call((Object)file.getName());
        name = name.substring(0, name.length() - 4);
        destinationDir = new File(destinationDir, name);
        copy.setDescription("Expands " + file.getName() + " into " + project.relativePath((Object)destinationDir) + ".");
        copy.setDestinationDir(destinationDir);
        return copy;
    }

    private void _addTasksExpandJSCompileDependencies(TranspileJSTask transpileJSTask, NpmInstallTask npmInstallTask, Configuration configuration) {
        Project project = transpileJSTask.getProject();
        RenameDependencyClosure renameDependencyClosure = new RenameDependencyClosure(project, new String[]{configuration.getName()});
        for (File file : configuration) {
            Copy copy = this._addTaskExpandCompileDependency(project, file, npmInstallTask.getNodeModulesDir(), "expandJSCompileDependency", renameDependencyClosure);
            transpileJSTask.dependsOn(new Object[]{copy});
        }
    }

    private void _addTasksExpandSoyCompileDependencies(TranspileJSTask transpileJSTask, Configuration configuration) {
        Project project = transpileJSTask.getProject();
        RenameDependencyClosure renameDependencyClosure = new RenameDependencyClosure(project, new String[]{configuration.getName()});
        for (File file : configuration) {
            Copy copy = this._addTaskExpandCompileDependency(project, file, project.getBuildDir(), "expandSoyCompileDependency", renameDependencyClosure);
            transpileJSTask.dependsOn(new Object[]{copy});
            String path = FileUtil.getAbsolutePath((File)copy.getDestinationDir());
            path = path + "/META-INF/resources/**/*.soy";
            transpileJSTask.soyDependency(path);
        }
    }

    private TranspileJSTask _addTaskTranspileJS(Project project) {
        final TranspileJSTask transpileJSTask = (TranspileJSTask)GradleUtil.addTask((Project)project, (String)TRANSPILE_JS_TASK_NAME, TranspileJSTask.class);
        transpileJSTask.setDescription("Transpiles JS files.");
        transpileJSTask.setGroup("build");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JSTranspilerPlugin.this._configureTaskTranspileJSForJavaPlugin(transpileJSTask);
            }
        });
        return transpileJSTask;
    }

    private void _configureTasksTranspileJS(Project project, final DownloadNodeModuleTask downloadMetalCliTask, final ExecuteNpmTask npmInstallTask) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(TranspileJSTask.class, (Action)new Action<TranspileJSTask>(){

            public void execute(TranspileJSTask transpileJSTask) {
                JSTranspilerPlugin.this._configureTaskTranspileJS(transpileJSTask, downloadMetalCliTask, npmInstallTask);
            }
        });
    }

    private void _configureTaskTranspileJS(TranspileJSTask transpileJSTask, final DownloadNodeModuleTask downloadMetalCliTask, final ExecuteNpmTask npmInstallTask) {
        FileCollection fileCollection = transpileJSTask.getSourceFiles();
        if (!transpileJSTask.isEnabled() || transpileJSTask.isSkipWhenEmpty() && fileCollection.isEmpty()) {
            transpileJSTask.setDependsOn(Collections.emptySet());
            transpileJSTask.setEnabled(false);
            return;
        }
        transpileJSTask.dependsOn(new Object[]{downloadMetalCliTask, npmInstallTask});
        transpileJSTask.setScriptFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(downloadMetalCliTask.getModuleDir(), "index.js");
            }
        });
        transpileJSTask.soyDependency(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return npmInstallTask.getWorkingDir() + "/node_modules/lexicon*/src/**/*.soy";
            }
        }, new Callable<String>(){

            @Override
            public String call() throws Exception {
                return npmInstallTask.getWorkingDir() + "/node_modules/metal*/src/**/*.soy";
            }
        });
    }

    private void _configureTaskTranspileJSForJavaPlugin(TranspileJSTask transpileJSTask) {
        transpileJSTask.mustRunAfter(new Object[]{"processResources"});
        Project project = transpileJSTask.getProject();
        final SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        transpileJSTask.setSourceDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = JSTranspilerPlugin.this._getSrcDir(sourceSet.getResources());
                return new File(resourcesDir, "META-INF/resources");
            }
        });
        transpileJSTask.setWorkingDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return new File(sourceSetOutput.getResourcesDir(), "META-INF/resources");
            }
        });
        Task classesTask = GradleUtil.getTask((Project)project, (String)"classes");
        classesTask.dependsOn(new Object[]{transpileJSTask});
    }

    private File _getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

