/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.js.transpiler;

import com.liferay.gradle.plugins.js.transpiler.TranspileJSTask;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeModuleTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;

public class JSTranspilerPlugin
implements Plugin<Project> {
    public static final String DOWNLOAD_METAL_CLI_TASK_NAME = "downloadMetalCli";
    public static final String TRANSPILE_JS_TASK_NAME = "transpileJS";
    private static final String _METAL_CLI_VERSION = "1.3.1";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        final ExecuteNpmTask npmInstallTask = (ExecuteNpmTask)GradleUtil.getTask((Project)project, (String)"npmInstall");
        final DownloadNodeModuleTask downloadMetalCliTask = this._addTaskDownloadMetalCli(project);
        this._addTaskTranspileJS(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                JSTranspilerPlugin.this._configureTasksTranspileJS(project, downloadMetalCliTask, npmInstallTask);
            }
        });
    }

    private DownloadNodeModuleTask _addTaskDownloadMetalCli(Project project) {
        DownloadNodeModuleTask downloadNodeModuleTask = (DownloadNodeModuleTask)GradleUtil.addTask((Project)project, (String)DOWNLOAD_METAL_CLI_TASK_NAME, DownloadNodeModuleTask.class);
        downloadNodeModuleTask.setModuleName((Object)"metal-cli");
        downloadNodeModuleTask.setModuleVersion((Object)_METAL_CLI_VERSION);
        return downloadNodeModuleTask;
    }

    private TranspileJSTask _addTaskTranspileJS(Project project) {
        final TranspileJSTask transpileJSTask = (TranspileJSTask)GradleUtil.addTask((Project)project, (String)TRANSPILE_JS_TASK_NAME, TranspileJSTask.class);
        transpileJSTask.setDescription("Transpiles JS files.");
        transpileJSTask.setGroup("build");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JSTranspilerPlugin.this._configureTaskTranspileJSForJavaPlugin(transpileJSTask);
            }
        });
        return transpileJSTask;
    }

    private void _configureTasksTranspileJS(Project project, final DownloadNodeModuleTask downloadMetalCliTask, final ExecuteNpmTask npmInstallTask) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(TranspileJSTask.class, (Action)new Action<TranspileJSTask>(){

            public void execute(TranspileJSTask transpileJSTask) {
                JSTranspilerPlugin.this._configureTaskTranspileJS(transpileJSTask, downloadMetalCliTask, npmInstallTask);
            }
        });
    }

    private void _configureTaskTranspileJS(TranspileJSTask transpileJSTask, final DownloadNodeModuleTask downloadMetalCliTask, final ExecuteNpmTask npmInstallTask) {
        FileCollection fileCollection = transpileJSTask.getSourceFiles();
        if (!transpileJSTask.isEnabled() || fileCollection.isEmpty()) {
            transpileJSTask.setDependsOn(Collections.emptySet());
            transpileJSTask.setEnabled(false);
            return;
        }
        transpileJSTask.dependsOn(new Object[]{downloadMetalCliTask, npmInstallTask});
        transpileJSTask.setScriptFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(downloadMetalCliTask.getModuleDir(), "index.js");
            }
        });
        transpileJSTask.soyDependency(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return npmInstallTask.getWorkingDir() + "/node_modules/metal*/src/**/*.soy";
            }
        });
    }

    private void _configureTaskTranspileJSForJavaPlugin(TranspileJSTask transpileJSTask) {
        transpileJSTask.mustRunAfter(new Object[]{"processResources"});
        Project project = transpileJSTask.getProject();
        final SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        transpileJSTask.setSourceDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = JSTranspilerPlugin.this._getSrcDir(sourceSet.getResources());
                return new File(resourcesDir, "META-INF/resources");
            }
        });
        transpileJSTask.setWorkingDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return new File(sourceSetOutput.getResourcesDir(), "META-INF/resources");
            }
        });
        Task classesTask = GradleUtil.getTask((Project)project, (String)"classes");
        classesTask.dependsOn(new Object[]{transpileJSTask});
    }

    private File _getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

