/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.js.module.config.generator;

import com.liferay.gradle.plugins.js.module.config.generator.ConfigJSModulesTask;
import com.liferay.gradle.plugins.js.module.config.generator.JSModuleConfigGeneratorExtension;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeModuleTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;

public class JSModuleConfigGeneratorPlugin
implements Plugin<Project> {
    public static final String CONFIG_JS_MODULES_TASK_NAME = "configJSModules";
    public static final String DOWNLOAD_LFR_MODULE_CONFIG_GENERATOR_TASK_NAME = "downloadLfrModuleConfigGenerator";
    public static final String EXTENSION_NAME = "jsModuleConfigGenerator";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        JSModuleConfigGeneratorExtension jsModuleConfigGeneratorExtension = (JSModuleConfigGeneratorExtension)GradleUtil.addExtension((ExtensionAware)project, (String)EXTENSION_NAME, JSModuleConfigGeneratorExtension.class);
        this.addTaskDownloadLfrModuleConfigGenerator(project, jsModuleConfigGeneratorExtension);
        this.addTaskConfigJSModules(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                JSModuleConfigGeneratorPlugin.this.configureTasksConfigJSModules(project);
            }
        });
    }

    protected ConfigJSModulesTask addTaskConfigJSModules(final Project project) {
        ConfigJSModulesTask configJSModulesTask = (ConfigJSModulesTask)GradleUtil.addTask((Project)project, (String)CONFIG_JS_MODULES_TASK_NAME, ConfigJSModulesTask.class);
        configJSModulesTask.setDescription("Generates the config file needed to load AMD files via combo loader in Liferay.");
        configJSModulesTask.setGroup("build");
        configJSModulesTask.setModuleConfigFile(project.file((Object)"bower.json"));
        configJSModulesTask.setOutputFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return new File(sourceSetOutput.getResourcesDir(), "META-INF/config.json");
            }
        });
        Task classesTask = GradleUtil.getTask((Project)project, (String)"classes");
        classesTask.dependsOn(new Object[]{configJSModulesTask});
        return configJSModulesTask;
    }

    protected DownloadNodeModuleTask addTaskDownloadLfrModuleConfigGenerator(Project project, final JSModuleConfigGeneratorExtension jsModuleConfigGeneratorExtension) {
        DownloadNodeModuleTask downloadLfrModuleConfigGeneratorTask = (DownloadNodeModuleTask)GradleUtil.addTask((Project)project, (String)DOWNLOAD_LFR_MODULE_CONFIG_GENERATOR_TASK_NAME, DownloadNodeModuleTask.class);
        downloadLfrModuleConfigGeneratorTask.setModuleName((Object)"lfr-module-config-generator");
        downloadLfrModuleConfigGeneratorTask.setModuleVersion((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return jsModuleConfigGeneratorExtension.getVersion();
            }
        });
        return downloadLfrModuleConfigGeneratorTask;
    }

    protected void configureTaskConfigJSModulesEnabled(ConfigJSModulesTask configJSModulesTask) {
        File file = configJSModulesTask.getModuleConfigFile();
        if (file == null || !file.exists()) {
            configJSModulesTask.setDependsOn(Collections.emptySet());
            configJSModulesTask.setEnabled(false);
        }
    }

    protected void configureTasksConfigJSModules(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ConfigJSModulesTask.class, (Action)new Action<ConfigJSModulesTask>(){

            public void execute(ConfigJSModulesTask configJSModulesTask) {
                JSModuleConfigGeneratorPlugin.this.configureTaskConfigJSModulesEnabled(configJSModulesTask);
            }
        });
    }
}

