/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.source.formatter.FormatSourceTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.plugins.testray.TestrayPlugin;

import org.gradle.api.Plugin;
import org.gradle.api.Project;

/**
 * @author Andrea Di Giorgi
 */
public class PoshiDefaultsPlugin implements Plugin<Project> {

	public static final String FORMAT_POSHI_TASK_NAME = "formatPoshi";

	@Override
	public void apply(Project project) {
		GradleUtil.applyPlugin(project, PoshiRunnerDefaultsPlugin.class);
		GradleUtil.applyPlugin(
			project, PoshiRunnerResourcesDefaultsPlugin.class);
		GradleUtil.applyPlugin(project, SourceFormatterPlugin.class);
		GradleUtil.applyPlugin(project, TestrayPlugin.class);

		_addTaskFormatPoshi(project);
	}

	private FormatSourceTask _addTaskFormatPoshi(Project project) {
		FormatSourceTask formatSourceTask = GradleUtil.addTask(
			project, FORMAT_POSHI_TASK_NAME, FormatSourceTask.class);

		formatSourceTask.setDescription(
			"Runs Liferay Source Formatter to format Poshi files.");
		formatSourceTask.setFileExtensions(
			new String[] {"function", "macro", "path", "testcase"});
		formatSourceTask.setGroup("formatting");

		return formatSourceTask;
	}

}