/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.defaults.internal.util;

import aQute.bnd.osgi.Constants;

import com.liferay.gradle.util.Validator;

import java.io.File;

import java.nio.file.Files;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;

import org.gradle.api.Project;
import org.gradle.util.GUtil;

/**
 * @author Peter Shin
 */
public class CIUtil {

	public static boolean isExcludedDependencyProject(
		Project project, Project dependencyProject) {

		File bndFile = project.file("bnd.bnd");

		if (!Files.exists(bndFile.toPath())) {
			return false;
		}

		File dependencyBndFile = dependencyProject.file("bnd.bnd");

		if (!Files.exists(dependencyBndFile.toPath())) {
			return false;
		}

		Properties dependencyProperties = GUtil.loadProperties(
			dependencyBndFile);

		String dependencyExportPackage = dependencyProperties.getProperty(
			Constants.EXPORT_PACKAGE);

		if (Validator.isNotNull(dependencyExportPackage)) {
			Properties properties = GUtil.loadProperties(bndFile);

			String importPackage = properties.getProperty(
				Constants.IMPORT_PACKAGE);

			if (Validator.isNull(importPackage)) {
				return false;
			}

			List<String> importPackages = Arrays.asList(
				importPackage.split(","));

			for (String exportPackage : dependencyExportPackage.split(",")) {
				if (!importPackages.contains("!" + exportPackage)) {
					return false;
				}
			}
		}

		return true;
	}

	public static boolean isRunningInCIEnvironment() {
		if (Validator.isNotNull(System.getenv("JENKINS_HOME"))) {
			return true;
		}

		return false;
	}

	public static boolean isRunningInCIPatcherEnvironment() {
		if (Validator.isNotNull(
				System.getenv("FIX_PACKS_RELEASE_ENVIRONMENT"))) {

			return true;
		}

		return false;
	}

}