/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.defaults.internal.util;

import java.io.File;

import org.gradle.api.specs.Spec;

/**
 * @author Andrea Di Giorgi
 */
public class NameSuffixFileSpec implements Spec<File> {

	public NameSuffixFileSpec(String... suffixes) {
		_suffixes = suffixes;
	}

	@Override
	public boolean isSatisfiedBy(File file) {
		String name = file.getName();

		for (String suffix : _suffixes) {
			if (name.endsWith(suffix)) {
				return true;
			}
		}

		return false;
	}

	private final String[] _suffixes;

}