/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.tasks;

import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class WriteFindBugsProjectTask
extends DefaultTask {
    private FileCollection _auxClasspath;
    private FileCollection _classpath;
    private Object _outputFile;
    private Object _projectName;
    private FileCollection _srcDirs;

    public WriteFindBugsProjectTask() {
        Project project = this.getProject();
        this._auxClasspath = project.files(new Object[0]);
        this._classpath = project.files(new Object[0]);
        this._srcDirs = project.files(new Object[0]);
    }

    public WriteFindBugsProjectTask auxClasspath(Object ... auxClasspath) {
        Project project = this.getProject();
        ConfigurableFileCollection fileCollection = project.files(auxClasspath);
        this._auxClasspath = this._auxClasspath.plus((FileCollection)fileCollection);
        return this;
    }

    public WriteFindBugsProjectTask classpath(Object ... classpath) {
        Project project = this.getProject();
        ConfigurableFileCollection fileCollection = project.files(classpath);
        this._classpath = this._classpath.plus((FileCollection)fileCollection);
        return this;
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getAuxClasspath() {
        return this._auxClasspath;
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getClasspath() {
        return this._classpath;
    }

    @OutputFile
    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    @Input
    public String getProjectName() {
        return GradleUtil.toString((Object)this._projectName);
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSrcDirs() {
        return this._srcDirs;
    }

    public void setAuxClasspath(FileCollection auxClasspath) {
        this._auxClasspath = auxClasspath;
    }

    public void setClasspath(FileCollection classpath) {
        this._classpath = classpath;
    }

    public void setOutputFile(Object outputFile) {
        this._outputFile = outputFile;
    }

    public void setProjectName(Object projectName) {
        this._projectName = projectName;
    }

    public void setSrcDirs(FileCollection srcDirs) {
        this._srcDirs = srcDirs;
    }

    public WriteFindBugsProjectTask srcDirs(Object ... srcDirs) {
        Project project = this.getProject();
        ConfigurableFileCollection fileCollection = project.files(srcDirs);
        this._srcDirs = this._srcDirs.plus((FileCollection)fileCollection);
        return this;
    }

    @TaskAction
    public void writeFindBugsProject() throws Exception {
        File outputFile = this.getOutputFile();
        Path outputPath = outputFile.toPath();
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(outputFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            bufferedWriter.write(System.lineSeparator());
            bufferedWriter.write(System.lineSeparator());
            bufferedWriter.write("<Project projectName=\"");
            bufferedWriter.write(this.getProjectName());
            bufferedWriter.write("\">");
            bufferedWriter.write(System.lineSeparator());
            this._writeFileElements(bufferedWriter, "AuxClasspathEntry", this._auxClasspath);
            this._writeFileElements(bufferedWriter, "Jar", this._classpath);
            this._writeFileElements(bufferedWriter, "SrcDir", this._srcDirs);
            bufferedWriter.write("</Project>");
        }
    }

    private void _writeFileElements(Writer writer, String name, FileCollection fileCollection) throws IOException {
        for (File file : fileCollection) {
            if (!file.exists()) continue;
            writer.write("\t<");
            writer.write(name);
            writer.write(62);
            writer.write(FileUtil.getAbsolutePath((File)file));
            writer.write("</");
            writer.write(name);
            writer.write(62);
            writer.write(System.lineSeparator());
        }
    }
}

