/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.util.ArrayUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskInputs;

public class FileUtil
extends com.liferay.gradle.util.FileUtil {
    public static boolean contains(File file, String s) throws IOException {
        Path path = file.toPath();
        if (Files.notExists(path, new LinkOption[0])) {
            return false;
        }
        String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        return content.contains(s);
    }

    public static File findFile(File dir, final String fileName) throws IOException {
        final AtomicReference<Object> file = new AtomicReference<Object>(null);
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                Path path = dirPath.resolve(fileName);
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    file.set(path.toFile());
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return file.get();
    }

    public static File[] getDirectories(File dir) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    public static File[] getFiles(File dir, final String prefix, final String suffix) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String name = file.getName();
                if (!name.startsWith(prefix)) {
                    return false;
                }
                return name.endsWith(suffix);
            }
        });
    }

    public static FileTree getJarsFileTree(Project project, File dir, String ... excludes) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", dir);
        if (ArrayUtil.isNotEmpty((Object[])excludes)) {
            args.put("excludes", Arrays.asList(excludes));
        }
        args.put("include", "*.jar");
        return project.fileTree(args);
    }

    public static String getRelativePath(Project project, File file) {
        String relativePath = project.relativePath((Object)file);
        return relativePath.replace('\\', '/');
    }

    public static String getUrl(File file) {
        URI uri = file.toURI();
        try {
            uri = new URI("file", "", uri.getPath(), null, null);
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new GradleException("Unable to create URI for " + file, (Throwable)uriSyntaxException);
        }
        return uri.toString();
    }

    public static boolean hasFiles(FileCollection fileCollection, Spec<File> spec) {
        return !(fileCollection = fileCollection.filter(spec)).isEmpty();
    }

    public static boolean hasSourceFiles(Task task, Spec<File> spec) {
        if (FileUtil.exists((Project)task.getProject(), (String)".lfrbuild-releng-skip-source")) {
            return false;
        }
        TaskInputs taskInputs = task.getInputs();
        return FileUtil.hasFiles(taskInputs.getSourceFiles(), spec);
    }

    public static FileCollection join(FileCollection ... fileCollections) {
        FileCollection joinedFileCollection = null;
        for (FileCollection fileCollection : fileCollections) {
            joinedFileCollection = joinedFileCollection == null ? fileCollection : joinedFileCollection.plus(fileCollection);
        }
        return joinedFileCollection;
    }

    public static void replace(Path path, String regex, String firstGroupReplacement) throws IOException {
        String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        int groupCount = matcher.groupCount();
        content = content.substring(0, matcher.start(groupCount)) + firstGroupReplacement + content.substring(matcher.end(groupCount));
        Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static void writeProperties(File file, Map<?, ?> properties) {
        File dir = file.getParentFile();
        dir.mkdirs();
        properties = new TreeMap(properties);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(file.toPath(), StandardCharsets.ISO_8859_1, new OpenOption[0]);){
            boolean firstLine = true;
            for (Map.Entry<?, ?> entry : properties.entrySet()) {
                String key = GradleUtil.toString(entry.getKey());
                String value = GradleUtil.toString(entry.getValue());
                if (firstLine) {
                    firstLine = false;
                } else {
                    bufferedWriter.newLine();
                }
                bufferedWriter.write(key);
                bufferedWriter.write(61);
                bufferedWriter.write(value);
            }
        }
        catch (IOException ioException) {
            throw new UncheckedIOException((Throwable)ioException);
        }
    }
}

