/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;

import java.io.File;

import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

/**
 * @author Peter Shin
 */
public class LiferayProfileDXPPlugin implements Plugin<Project> {

	public static final Plugin<Project> INSTANCE =
		new LiferayProfileDXPPlugin();

	@Override
	public void apply(Project project) {
		File portalRootDir = GradleUtil.getRootDir(
			project.getRootProject(), "portal-impl");

		if (portalRootDir != null) {
			File buildProfileDXPPropertiesFile = new File(
				portalRootDir, "build.profile-dxp.properties");

			if (!buildProfileDXPPropertiesFile.exists()) {
				StringBuilder sb = new StringBuilder();

				sb.append("Please run the following command to setup the ");
				sb.append("build profile for DXP:\n");
				sb.append(portalRootDir);
				sb.append("$ ant setup-profile-dxp");

				throw new GradleException(sb.toString());
			}
		}
	}

}