/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.github.jk1.license.LicenseReportExtension;
import com.github.jk1.license.ManifestData;
import com.github.jk1.license.ModuleData;
import com.github.jk1.license.PomData;
import com.github.jk1.license.ProjectData;
import com.github.jk1.license.render.LicenseDataCollector;
import com.github.jk1.license.render.ReportRenderer;
import com.liferay.gradle.plugins.defaults.internal.util.XMLUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilder;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VersionsXmlReportRenderer
implements ReportRenderer {
    private final String _fileName;
    private final LicenseReportExtension _licenseReportExtension;
    private final Callable<String> _moduleFileNamePrefixCallable;

    public VersionsXmlReportRenderer(String fileName, LicenseReportExtension licenseReportExtension, Callable<String> moduleFileNamePrefixCallable) {
        this._fileName = fileName;
        this._licenseReportExtension = licenseReportExtension;
        this._moduleFileNamePrefixCallable = moduleFileNamePrefixCallable;
    }

    public void render(ProjectData projectData) {
        try {
            this._render(projectData);
        }
        catch (IOException ioException) {
            throw new UncheckedIOException((Throwable)ioException);
        }
        catch (Exception exception) {
            throw new GradleException("Unable to render " + projectData, (Throwable)exception);
        }
    }

    protected String getLicenseName(String moduleFileName, ModuleData moduleData) {
        List moduleLicenseInfo = LicenseDataCollector.singleModuleLicenseInfo((ModuleData)moduleData);
        return (String)moduleLicenseInfo.get(1);
    }

    protected String getLicenseUrl(String moduleFileName, ModuleData moduleData) {
        List moduleLicenseInfo = LicenseDataCollector.singleModuleLicenseInfo((ModuleData)moduleData);
        return (String)moduleLicenseInfo.get(2);
    }

    protected boolean isExcluded(String moduleFileName, ModuleData moduleData) {
        return false;
    }

    private void _appendLibraryElement(Document document, Element librariesElement, String moduleFileName, ModuleData moduleData) {
        List moduleLicenseInfo = LicenseDataCollector.singleModuleLicenseInfo((ModuleData)moduleData);
        String projectUrl = (String)moduleLicenseInfo.get(0);
        String licenseName = this.getLicenseName(moduleFileName, moduleData);
        String licenseUrl = this.getLicenseUrl(moduleFileName, moduleData);
        Element libraryElement = XMLUtil.appendElement(document, librariesElement, "library");
        XMLUtil.appendElement(document, libraryElement, "file-name", moduleFileName);
        XMLUtil.appendElement(document, libraryElement, "version", moduleData.getVersion());
        XMLUtil.appendElement(document, libraryElement, "project-name", this._getProjectName(moduleData));
        XMLUtil.appendElement(document, libraryElement, "project-url", projectUrl);
        Element licensesElement = XMLUtil.appendElement(document, libraryElement, "licenses");
        Element licenseElement = XMLUtil.appendElement(document, licensesElement, "license");
        XMLUtil.appendElement(document, licenseElement, "license-name", licenseName);
        XMLUtil.appendElement(document, licenseElement, "license-url", licenseUrl);
    }

    private String _getProjectName(ModuleData moduleData) {
        String name = null;
        for (ManifestData manifestData : moduleData.getManifests()) {
            name = this._getProjectName(manifestData.getName(), name);
        }
        for (PomData pomData : moduleData.getPoms()) {
            name = this._getProjectName(pomData.getName(), name);
        }
        if (Validator.isNotNull(name)) {
            return name;
        }
        return moduleData.getGroup() + ":" + moduleData.getName();
    }

    private String _getProjectName(String name, String previousName) {
        if (Validator.isNull((String)name) || !Character.isAlphabetic(name.charAt(0))) {
            return previousName;
        }
        if (Validator.isNull((String)previousName) || name.indexOf(32) != -1 && previousName.indexOf(32) == -1) {
            return name;
        }
        if (name.length() > previousName.length()) {
            return name;
        }
        return previousName;
    }

    private void _render(ProjectData projectData) throws Exception {
        TreeMap<String, ModuleData> fileNameModuleDataMap = new TreeMap<String, ModuleData>();
        String moduleFileNamePrefix = this._moduleFileNamePrefixCallable.call();
        for (ModuleData moduleData : projectData.getAllDependencies()) {
            String moduleFileName = moduleFileNamePrefix + "!" + moduleData.getName() + ".jar";
            if (this.isExcluded(moduleFileName, moduleData)) continue;
            fileNameModuleDataMap.put(moduleFileName, moduleData);
        }
        DocumentBuilder documentBuilder = XMLUtil.getDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element versionsElement = XMLUtil.appendElement(document, document, "versions");
        Element versionElement = XMLUtil.appendElement(document, versionsElement, "version");
        Element librariesElement = XMLUtil.appendElement(document, versionElement, "libraries");
        for (Map.Entry entry : fileNameModuleDataMap.entrySet()) {
            this._appendLibraryElement(document, librariesElement, (String)entry.getKey(), (ModuleData)entry.getValue());
        }
        File file = new File(this._licenseReportExtension.outputDir, this._fileName);
        XMLUtil.write(document, file);
    }
}

