/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.defaults;

import com.github.erdi.gradle.webdriver.WebDriverBinariesPluginExtension;

import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.poshi.runner.PoshiRunnerPlugin;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.resources.TextResourceFactory;

/**
 * @author Andrea Di Giorgi
 */
public class PoshiRunnerDefaultsPlugin implements Plugin<Project> {

	@Override
	public void apply(Project project) {
		GradlePluginsDefaultsUtil.configureRepositories(project, null);

		GradleUtil.applyPlugin(project, PoshiRunnerPlugin.class);

		_configurePoshiRunner(project);
	}

	private void _configurePoshiRunner(Project project) {
		WebDriverBinariesPluginExtension webDriverBinariesPluginExtension =
			GradleUtil.getExtension(
				project, WebDriverBinariesPluginExtension.class);

		webDriverBinariesPluginExtension.setChromedriver("86.0.4240.22");

		ResourceHandler resourceHandler = project.getResources();

		TextResourceFactory textResourceFactory = resourceHandler.getText();

		webDriverBinariesPluginExtension.setDriverUrlsConfiguration(
			textResourceFactory.fromUri(_WEB_DRIVER_URI));
	}

	private static final String _WEB_DRIVER_URI =
		"http://mirrors.lax.liferay.com/raw.githubusercontent.com" +
			"/webdriverextensions/webdriverextensions-maven-plugin-repository" +
				"/master/repository-3.0.json";

}