/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.defaults.internal.util;

import java.io.IOException;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

import java.util.LinkedList;
import java.util.Queue;

import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.UncheckedIOException;

/**
 * @author Andrea Di Giorgi
 */
public class BackupFilesBuildAdapter extends BuildAdapter {

	public void backUp(Path path) {
		try {
			Path backupPath = _getBackupPath(path);

			Files.copy(path, backupPath, StandardCopyOption.REPLACE_EXISTING);

			_paths.add(path);
		}
		catch (IOException ioException) {
			throw new UncheckedIOException(ioException);
		}
	}

	@Override
	public void buildFinished(BuildResult buildResult) {
		try {
			while (!_paths.isEmpty()) {
				Path path = _paths.remove();

				Path backupPath = _getBackupPath(path);

				if (Files.exists(backupPath)) {
					Files.move(
						backupPath, path, StandardCopyOption.REPLACE_EXISTING);
				}
			}
		}
		catch (IOException ioException) {
			throw new UncheckedIOException(ioException);
		}
	}

	private Path _getBackupPath(Path path) {
		return Paths.get(path.toString() + ".backup");
	}

	private final Queue<Path> _paths = new LinkedList<>();

}