/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.ExtensionAware;

public class LiferaySettingsPlugin
implements Plugin<Settings> {
    public static final String PROJECT_PATH_PREFIX_PROPERTY_NAME = "project.path.prefix";

    public void apply(Settings settings) {
        File rootDir = settings.getRootDir();
        Path rootDirPath = rootDir.toPath();
        String projectPathPrefix = GradleUtil.getProperty((ExtensionAware)settings, (String)PROJECT_PATH_PREFIX_PROPERTY_NAME, (String)"");
        if (Validator.isNotNull((String)projectPathPrefix)) {
            if (projectPathPrefix.charAt(0) != ':') {
                projectPathPrefix = ":" + projectPathPrefix;
            }
            if (projectPathPrefix.charAt(projectPathPrefix.length() - 1) == ':') {
                projectPathPrefix = projectPathPrefix.substring(0, projectPathPrefix.length() - 1);
            }
        }
        try {
            Path projectPathRootDirPath = rootDirPath;
            if (this._isPortalRootDirPath(rootDirPath)) {
                projectPathRootDirPath = rootDirPath.resolve("modules");
            }
            this._includeProjects(settings, projectPathRootDirPath, projectPathPrefix);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    private Set<Path> _getDirPaths(String key, Path rootDirPath) {
        String dirNamesString = System.getProperty(key);
        if (Validator.isNull((String)dirNamesString)) {
            return Collections.emptySet();
        }
        HashSet<Path> dirPaths = new HashSet<Path>();
        for (String dirName : dirNamesString.split(",")) {
            dirPaths.add(rootDirPath.resolve(dirName));
        }
        return dirPaths;
    }

    private <T extends Enum<T>> Set<T> _getFlags(String prefix, Class<T> clazz) {
        EnumSet<T> flags = EnumSet.allOf(clazz);
        Iterator iterator = flags.iterator();
        while (iterator.hasNext()) {
            Enum flag = (Enum)iterator.next();
            String flagName = flag.toString();
            flagName = flagName.replace('_', '.');
            flagName = flagName.toLowerCase();
            if (Boolean.getBoolean(prefix + flagName)) continue;
            iterator.remove();
        }
        return flags;
    }

    private ProjectDirType _getProjectDirType(Path dirPath) {
        if (Files.exists(dirPath.resolve("build.xml"), new LinkOption[0])) {
            return ProjectDirType.ANT_PLUGIN;
        }
        if (Files.exists(dirPath.resolve("bnd.bnd"), new LinkOption[0])) {
            return ProjectDirType.MODULE;
        }
        Path applicationPropertiesPath = dirPath.resolve("src/main/resources/application.properties");
        if (Files.exists(applicationPropertiesPath, new LinkOption[0])) {
            return ProjectDirType.SPRING_BOOT;
        }
        if (Files.exists(dirPath.resolve("gulpfile.js"), new LinkOption[0])) {
            return ProjectDirType.THEME;
        }
        return ProjectDirType.UNKNOWN;
    }

    private void _includeProject(Settings settings, Path projectDirPath, Path projectPathRootDirPath, String projectPathPrefix) {
        Path relativePath = projectPathRootDirPath.relativize(projectDirPath);
        String projectPath = relativePath.toString();
        projectPath = projectPathPrefix + ":" + projectPath.replace(File.separatorChar, ':');
        settings.include(new String[]{projectPath});
        ProjectDescriptor projectDescriptor = settings.findProject(projectPath);
        projectDescriptor.setProjectDir(projectDirPath.toFile());
    }

    private void _includeProjects(final Settings settings, final Path projectPathRootDirPath, final String projectPathPrefix) throws IOException {
        final String buildProfile = System.getProperty("build.profile");
        final Set<String> buildProfileFileNames = GradlePluginsDefaultsUtil.getBuildProfileFileNames(buildProfile, GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.releng.public", (boolean)true));
        final Set<Path> excludedDirPaths = this._getDirPaths("build.exclude.dirs", projectPathRootDirPath);
        final Set<Path> includedDirPaths = this._getDirPaths("build.include.dirs", projectPathRootDirPath);
        final Set<ProjectDirType> excludedProjectDirTypes = this._getFlags("build.exclude.", ProjectDirType.class);
        Files.walkFileTree(projectPathRootDirPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 10, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                Path dxpPath;
                if (dirPath.equals(projectPathRootDirPath)) {
                    return FileVisitResult.CONTINUE;
                }
                if (excludedDirPaths.contains(dirPath)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (buildProfileFileNames != null && !Objects.equals(buildProfile, "dxp") && dirPath.equals(dxpPath = projectPathRootDirPath.resolve("dxp"))) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                String dirName = String.valueOf(dirPath.getFileName());
                if (dirName.equals("build") || dirName.equals("node_modules") || dirName.equals("node_modules_cache")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                ProjectDirType projectDirType = LiferaySettingsPlugin.this._getProjectDirType(dirPath);
                if (projectDirType == ProjectDirType.UNKNOWN) {
                    return FileVisitResult.CONTINUE;
                }
                if (excludedProjectDirTypes.contains((Object)projectDirType)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (!includedDirPaths.isEmpty() && !LiferaySettingsPlugin.this._startsWith(dirPath, includedDirPaths)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (buildProfileFileNames != null) {
                    boolean found = false;
                    for (String fileName : buildProfileFileNames) {
                        if (!Files.exists(dirPath.resolve(fileName), new LinkOption[0])) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }
                LiferaySettingsPlugin.this._includeProject(settings, dirPath, projectPathRootDirPath, projectPathPrefix);
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
    }

    private boolean _isPortalRootDirPath(Path dirPath) {
        if (!Files.exists(dirPath.resolve("modules"), new LinkOption[0])) {
            return false;
        }
        return Files.exists(dirPath.resolve("portal-impl"), new LinkOption[0]);
    }

    private boolean _startsWith(Path path, Iterable<Path> parentPaths) {
        for (Path parentPath : parentPaths) {
            if (!path.startsWith(parentPath)) continue;
            return true;
        }
        return false;
    }

    private static enum ProjectDirType {
        ANT_PLUGIN,
        MODULE,
        SPRING_BOOT,
        THEME,
        UNKNOWN;

    }
}

