/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.tasks;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.internal.util.StringUtil;
import com.liferay.gradle.plugins.defaults.internal.util.XMLUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.RenameDependencyClosure;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.CopySpec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@CacheableTask
public class CopyIvyDependenciesTask
extends Copy {
    private final Configuration _configuration;
    private Closure<Map<String, Object>> _dependencyTransformClosure = Closure.IDENTITY;
    private Object _inputFile;

    public CopyIvyDependenciesTask() {
        this._configuration = this._createConfiguration();
        this.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                CopyIvyDependenciesTask copyIvyDependenciesTask = (CopyIvyDependenciesTask)task;
                copyIvyDependenciesTask.writeChecksumFile();
            }
        });
        this.from(this._configuration, (Closure)new Closure<Void>((Object)this.getProject()){

            public void doCall(CopySpec copySpec) {
                copySpec.rename((Closure)new RenameDependencyClosure(CopyIvyDependenciesTask.this.getProject(), new String[]{CopyIvyDependenciesTask.this._configuration.getName()}));
            }
        });
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public Closure<Map<String, Object>> getDependencyTransformClosure() {
        return this._dependencyTransformClosure;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getInputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._inputFile);
    }

    public void setDependencyTransformClosure(Closure<Map<String, Object>> dependencyVersionClosure) {
        this._dependencyTransformClosure = dependencyVersionClosure;
    }

    public void setInputFile(Object inputFile) {
        this._inputFile = inputFile;
    }

    public void writeChecksumFile() {
        Project project = this.getProject();
        project.ant((Closure)new Closure<Void>((Object)project){

            public void doCall(AntBuilder antBuilder) {
                antBuilder.invokeMethod("checksum", Collections.singletonMap("file", CopyIvyDependenciesTask.this.getInputFile()));
            }
        });
    }

    private void _addDependencies(DependencySet dependencySet) throws Exception {
        Project project = this.getProject();
        DependencyHandler dependencyHandler = project.getDependencies();
        DocumentBuilder documentBuilder = XMLUtil.getDocumentBuilder();
        Document document = documentBuilder.parse(this.getInputFile());
        NodeList dependencyNodeList = document.getElementsByTagName("dependency");
        for (int i = 0; i < dependencyNodeList.getLength(); ++i) {
            Element dependencyElement = (Element)dependencyNodeList.item(i);
            String conf = dependencyElement.getAttribute("conf");
            if (Validator.isNotNull((String)conf)) continue;
            Map<String, Object> dependencyNotation = new HashMap<String, Object>();
            dependencyNotation.put("group", dependencyElement.getAttribute("org"));
            dependencyNotation.put("name", dependencyElement.getAttribute("name"));
            dependencyNotation.put("version", dependencyElement.getAttribute("rev"));
            String transitive = dependencyElement.getAttribute("transitive");
            if (Validator.isNotNull((String)transitive)) {
                dependencyNotation.put("transitive", Boolean.parseBoolean(transitive));
            }
            dependencyNotation = (Map)this._dependencyTransformClosure.call(dependencyNotation);
            ModuleDependency moduleDependency = (ModuleDependency)dependencyHandler.create(dependencyNotation);
            NodeList excludeNodeList = dependencyElement.getElementsByTagName("exclude");
            for (int j = 0; j < excludeNodeList.getLength(); ++j) {
                String module;
                Element excludeElement = (Element)excludeNodeList.item(j);
                HashMap<String, String> args = new HashMap<String, String>();
                String group = excludeElement.getAttribute("org");
                if (Validator.isNotNull((String)group)) {
                    args.put("group", group);
                }
                if (Validator.isNotNull((String)(module = excludeElement.getAttribute("module")))) {
                    args.put("module", module);
                }
                moduleDependency.exclude(args);
            }
            dependencySet.add((Object)moduleDependency);
        }
    }

    private Configuration _createConfiguration() {
        Configuration configuration = GradleUtil.addConfiguration((Project)this.getProject(), (String)("ivy" + StringUtil.capitalize((String)this.getName())));
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                try {
                    CopyIvyDependenciesTask.this._addDependencies(dependencySet);
                }
                catch (IOException ioException) {
                    throw new UncheckedIOException((Throwable)ioException);
                }
                catch (Exception exception) {
                    throw new GradleException(exception.getMessage(), (Throwable)exception);
                }
            }
        });
        configuration.setDescription("Configures Ivy dependencies for " + (Object)((Object)this));
        configuration.setVisible(false);
        return configuration;
    }
}

