/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.plugins.whip.WhipExtension;
import com.liferay.gradle.plugins.whip.WhipPlugin;
import com.liferay.gradle.plugins.whip.WhipTaskExtension;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.testing.Test;

public class WhipDefaultsPlugin
extends BaseDefaultsPlugin<WhipPlugin> {
    public static final Plugin<Project> INSTANCE = new WhipDefaultsPlugin();
    private static final String _PORTAL_TOOL_NAME = "com.liferay.whip";

    protected void applyPluginDefaults(Project project, WhipPlugin whipPlugin) {
        WhipExtension whipExtension = (WhipExtension)GradleUtil.getExtension((ExtensionAware)project, WhipExtension.class);
        this._configureExtensionWhip(project, whipExtension);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                WhipDefaultsPlugin.this._configureTaskTest(test);
            }
        });
    }

    protected Class<WhipPlugin> getPluginClass() {
        return WhipPlugin.class;
    }

    private WhipDefaultsPlugin() {
    }

    private void _configureExtensionWhip(Project project, WhipExtension whipExtension) {
        String version = PortalTools.getVersion((Project)project, (String)_PORTAL_TOOL_NAME);
        if (Validator.isNotNull((String)version)) {
            whipExtension.setVersion(version);
        }
    }

    private void _configureTaskTest(Test test) {
        WhipTaskExtension whipTaskExtension = (WhipTaskExtension)GradleUtil.getExtension((ExtensionAware)test, WhipTaskExtension.class);
        whipTaskExtension.excludes(new Object[]{".*Test", ".*Test\\$.*", ".*\\$Proxy.*", "com/liferay/whip/.*"});
        whipTaskExtension.includes(new Object[]{"com/liferay/.*"});
    }
}

