/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.LiferayAntPlugin;
import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.cache.CacheExtension;
import com.liferay.gradle.plugins.cache.CachePlugin;
import com.liferay.gradle.plugins.cache.WriteDigestTask;
import com.liferay.gradle.plugins.cache.task.TaskCache;
import com.liferay.gradle.plugins.change.log.builder.BuildChangeLogTask;
import com.liferay.gradle.plugins.change.log.builder.ChangeLogBuilderPlugin;
import com.liferay.gradle.plugins.defaults.LiferayOSGiDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.LiferayThemeDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GitUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.internal.util.LiferayRelengUtil;
import com.liferay.gradle.plugins.defaults.tasks.MergeFilesTask;
import com.liferay.gradle.plugins.defaults.tasks.ReplaceRegexTask;
import com.liferay.gradle.plugins.defaults.tasks.WriteArtifactPublishCommandsTask;
import com.liferay.gradle.plugins.defaults.tasks.WritePropertiesTask;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.CollectionUtils;

public class LiferayRelengPlugin
implements Plugin<Project> {
    public static final String CLEAN_ARTIFACTS_PUBLISH_COMMANDS_TASK_NAME = "cleanArtifactsPublishCommands";
    public static final Plugin<Project> INSTANCE = new LiferayRelengPlugin();
    public static final String MERGE_ARTIFACTS_PUBLISH_COMMANDS = "mergeArtifactsPublishCommands";
    public static final String PRINT_DEPENDENT_ARTIFACT_TASK_NAME = "printDependentArtifact";
    public static final String PRINT_STALE_ARTIFACT_TASK_NAME = "printStaleArtifact";
    public static final String RECORD_ARTIFACT_TASK_NAME = "recordArtifact";
    public static final String UPDATE_VERSION_TASK_NAME = "updateVersion";
    public static final String WRITE_ARTIFACT_PUBLISH_COMMANDS = "writeArtifactPublishCommands";
    protected static final String RELENG_IGNORE_FILE_NAME = ".lfrbuild-releng-ignore";
    private static final String _LIFERAY_RELENG_APP_TITLE_PREFIX = "liferay.releng.app.title.prefix";
    private static final String _LIFERAY_RELENG_PUBLIC = "liferay.releng.public";
    private static final String _LIFERAY_RELENG_SUPPORTED = "liferay.releng.supported";

    public void apply(final Project project) {
        File relengDir = LiferayRelengUtil.getRelengDir(project);
        if (relengDir == null) {
            return;
        }
        GradleUtil.applyPlugin((Project)project, ChangeLogBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
        final BuildChangeLogTask buildChangeLogTask = (BuildChangeLogTask)GradleUtil.getTask((Project)project, (String)"buildChangeLog");
        WritePropertiesTask recordArtifactTask = this._addTaskRecordArtifact(project, relengDir);
        Delete cleanArtifactsPublishCommandsTask = this._addRootTaskCleanArtifactsPublishCommands(project.getGradle());
        MergeFilesTask mergeArtifactsPublishCommandsTask = this._addRootTaskMergeArtifactsPublishCommands(cleanArtifactsPublishCommandsTask);
        WriteArtifactPublishCommandsTask writeArtifactPublishCommandsTask = this._addTaskWriteArtifactPublishCommands(project, recordArtifactTask, cleanArtifactsPublishCommandsTask, mergeArtifactsPublishCommandsTask);
        mergeArtifactsPublishCommandsTask.mustRunAfter(new Object[]{writeArtifactPublishCommandsTask});
        this._addTaskPrintStaleArtifact(project, recordArtifactTask);
        this._addTaskPrintDependentArtifact(project);
        this._configureLiferayRelengProperties(project);
        this._configureTaskBuildChangeLog(buildChangeLogTask, relengDir);
        this._configureTaskUploadArchives(project, (Task)recordArtifactTask);
        GradleUtil.withPlugin(project, JavaPlugin.class, new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                LiferayRelengPlugin.this._configureTaskProcessResources(project, buildChangeLogTask);
            }
        });
    }

    private LiferayRelengPlugin() {
    }

    private Delete _addRootTaskCleanArtifactsPublishCommands(Gradle gradle) {
        StartParameter startParameter = gradle.getStartParameter();
        Project project = GradleUtil.getProject((Project)gradle.getRootProject(), (File)startParameter.getCurrentDir());
        TaskContainer taskContainer = project.getTasks();
        Delete delete = (Delete)taskContainer.findByName(CLEAN_ARTIFACTS_PUBLISH_COMMANDS_TASK_NAME);
        if (delete != null) {
            return delete;
        }
        delete = (Delete)GradleUtil.addTask((Project)project, (String)CLEAN_ARTIFACTS_PUBLISH_COMMANDS_TASK_NAME, Delete.class);
        delete.delete(new Object[]{new File(project.getBuildDir(), "artifacts-publish-commands")});
        delete.setDescription("Deletes the temporary directory that contains the artifacts publish commands.");
        return delete;
    }

    private MergeFilesTask _addRootTaskMergeArtifactsPublishCommands(Delete cleanArtifactsPublishCommandsTask) {
        Project rootProject = cleanArtifactsPublishCommandsTask.getProject();
        TaskContainer taskContainer = rootProject.getTasks();
        MergeFilesTask mergeFilesTask = (MergeFilesTask)((Object)taskContainer.findByName(MERGE_ARTIFACTS_PUBLISH_COMMANDS));
        if (mergeFilesTask != null) {
            return mergeFilesTask;
        }
        mergeFilesTask = (MergeFilesTask)GradleUtil.addTask((Project)rootProject, (String)MERGE_ARTIFACTS_PUBLISH_COMMANDS, MergeFilesTask.class);
        File dir = GradleUtil.toFile((Project)rootProject, (Object)CollectionUtils.first((Iterable)cleanArtifactsPublishCommandsTask.getDelete()));
        mergeFilesTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                MergeFilesTask mergeFilesTask = (MergeFilesTask)task;
                Logger logger = mergeFilesTask.getLogger();
                File file = mergeFilesTask.getOutputFile();
                if (file.exists()) {
                    boolean success = file.setExecutable(true);
                    if (!success) {
                        logger.error("Unable to set the owner's execute permission for {}", (Object)file);
                    }
                    if (logger.isQuietEnabled()) {
                        logger.quiet("Artifacts publish commands written in {}.", new Object[]{file});
                    }
                } else if (logger.isQuietEnabled()) {
                    logger.quiet("No artifacts publish commands are available.");
                }
            }
        });
        mergeFilesTask.setDescription("Merges the artifacts publish commands.");
        mergeFilesTask.setHeader("#!/bin/bash" + System.lineSeparator() + System.lineSeparator() + "set -e" + System.lineSeparator());
        mergeFilesTask.setInputFiles(new File(dir, "writeArtifactPublishCommands-step1.sh"), new File(dir, "writeArtifactPublishCommands-step2.sh"), new File(dir, "writeArtifactPublishCommands-step3.sh"));
        mergeFilesTask.setOutputFile(new File(dir, "artifacts-publish-commands.sh"));
        TaskOutputsInternal taskOutputs = mergeFilesTask.getOutputs();
        taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
        return mergeFilesTask;
    }

    private Task _addTaskPrintDependentArtifact(Project project) {
        Task task = project.task(PRINT_DEPENDENT_ARTIFACT_TASK_NAME);
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                File projectDir = project.getProjectDir();
                System.out.println(projectDir.getAbsolutePath());
            }
        });
        Spec<Task> onlyIfSpec = new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Pattern pattern;
                Matcher matcher;
                Project project = task.getProject();
                String ignoreProjectRegex = GradleUtil.getTaskPrefixedProperty((Task)task, (String)"ignore.project.regex");
                if (Validator.isNotNull((String)ignoreProjectRegex) && (matcher = (pattern = Pattern.compile(ignoreProjectRegex)).matcher(project.getName())).find()) {
                    return false;
                }
                if (GradlePluginsDefaultsUtil.isTestProject(project)) {
                    return false;
                }
                return LiferayRelengUtil.hasUnpublishedDependencies(project);
            }
        };
        task.onlyIf((Spec)onlyIfSpec);
        task.setDescription("Prints the project directory if this project contains dependencies to other projects.");
        task.setGroup("verification");
        return task;
    }

    private Task _addTaskPrintStaleArtifact(Project project, WritePropertiesTask recordArtifactTask) {
        final Task task = project.task(PRINT_STALE_ARTIFACT_TASK_NAME);
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                File projectDir = project.getProjectDir();
                System.out.println(projectDir.getAbsolutePath());
            }
        });
        task.setDescription("Prints the project directory if this project has been changed since the last publish.");
        task.setGroup("verification");
        this._configureTaskPrintStaleArtifactOnlyIf(project, task, recordArtifactTask);
        GradleUtil.withPlugin(project, LiferayOSGiDefaultsPlugin.class, new Action<LiferayOSGiDefaultsPlugin>(){

            public void execute(LiferayOSGiDefaultsPlugin liferayOSGiDefaultsPlugin) {
                LiferayRelengPlugin.this._configureTaskPrintStaleArtifactForOSGi(task);
            }
        });
        return task;
    }

    private WritePropertiesTask _addTaskRecordArtifact(Project project, File destinationDir) {
        final WritePropertiesTask writePropertiesTask = (WritePropertiesTask)GradleUtil.addTask((Project)project, (String)RECORD_ARTIFACT_TASK_NAME, WritePropertiesTask.class);
        writePropertiesTask.property("artifact.git.id", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return GitUtil.getGitResult(writePropertiesTask.getProject(), "rev-parse", "HEAD");
            }
        });
        writePropertiesTask.setDescription("Records the commit ID and the artifact URLs.");
        writePropertiesTask.setOutputFile(new File(destinationDir, "artifact.properties"));
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        PublishArtifactSet publishArtifactSet = configuration.getArtifacts();
        Action<PublishArtifact> action = new Action<PublishArtifact>(){

            public void execute(final PublishArtifact publishArtifact) {
                writePropertiesTask.property(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        String key = publishArtifact.getClassifier();
                        if (Validator.isNull((String)key)) {
                            key = publishArtifact.getType();
                            Project project = writePropertiesTask.getProject();
                            if ("jar".equals(key) && GradleUtil.hasPlugin(project, JavaPlugin.class) || "war".equals(key) && (GradleUtil.hasPlugin(project, LiferayAntPlugin.class) || GradleUtil.hasPlugin(project, LiferayThemePlugin.class))) {
                                key = null;
                            }
                        }
                        key = Validator.isNull((String)key) ? "artifact.url" : "artifact." + key + ".url";
                        return key;
                    }
                }, (Object)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return LiferayRelengUtil.getArtifactRemoteURL(writePropertiesTask.getProject(), publishArtifact, false);
                    }
                });
            }
        };
        publishArtifactSet.all((Action)action);
        return writePropertiesTask;
    }

    private WriteArtifactPublishCommandsTask _addTaskWriteArtifactPublishCommands(Project project, final WritePropertiesTask recordArtifactTask, Delete cleanArtifactsPublishCommandsTask, MergeFilesTask mergeArtifactsPublishCommandsTask) {
        final WriteArtifactPublishCommandsTask writeArtifactPublishCommandsTask = (WriteArtifactPublishCommandsTask)GradleUtil.addTask((Project)project, (String)WRITE_ARTIFACT_PUBLISH_COMMANDS, WriteArtifactPublishCommandsTask.class);
        writeArtifactPublishCommandsTask.dependsOn(new Object[]{cleanArtifactsPublishCommandsTask});
        writeArtifactPublishCommandsTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                Gradle gradle = project.getGradle();
                StartParameter startParameter = gradle.getStartParameter();
                if (startParameter.isParallelProjectExecutionEnabled()) {
                    throw new GradleException("Unable to run " + task + " in parallel");
                }
            }
        });
        writeArtifactPublishCommandsTask.finalizedBy(new Object[]{mergeArtifactsPublishCommandsTask});
        writeArtifactPublishCommandsTask.setArtifactPropertiesFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return recordArtifactTask.getOutputFile();
            }
        });
        writeArtifactPublishCommandsTask.setDescription("Prints the artifact publish commands if this project has been changed since the last publish.");
        writeArtifactPublishCommandsTask.setOutputDir(CollectionUtils.first((Iterable)cleanArtifactsPublishCommandsTask.getDelete()));
        this._configureTaskWriteArtifactPublishCommandsOnlyIf(project, writeArtifactPublishCommandsTask, recordArtifactTask);
        GradleUtil.withPlugin(project, LiferayOSGiDefaultsPlugin.class, new Action<LiferayOSGiDefaultsPlugin>(){

            public void execute(LiferayOSGiDefaultsPlugin liferayOSGiDefaultsPlugin) {
                LiferayRelengPlugin.this._configureTaskWriteArtifactPublishCommandsForOSGi(writeArtifactPublishCommandsTask);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                TaskContainer taskContainer = project.getTasks();
                Task task = (Task)taskContainer.findByName(LiferayRelengPlugin.UPDATE_VERSION_TASK_NAME);
                if (task instanceof ReplaceRegexTask) {
                    ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)task;
                    Map<String, FileCollection> matches = replaceRegexTask.getMatches();
                    writeArtifactPublishCommandsTask.prepNextFiles(matches.values());
                }
                if (GradleUtil.hasPlugin(project, CachePlugin.class)) {
                    CacheExtension cacheExtension = (CacheExtension)GradleUtil.getExtension((ExtensionAware)project, CacheExtension.class);
                    for (TaskCache taskCache : cacheExtension.getTasks()) {
                        writeArtifactPublishCommandsTask.prepNextFiles(new File(taskCache.getCacheDir(), ".digest"));
                    }
                }
                if (GradleUtil.hasPlugin(project, LiferayThemeDefaultsPlugin.class)) {
                    WriteDigestTask writeDigestTask = (WriteDigestTask)GradleUtil.getTask((Project)project, (String)"writeParentThemesDigest");
                    writeArtifactPublishCommandsTask.prepNextCommitFile("digest", writeDigestTask.getDigestFile());
                }
            }
        });
        return writeArtifactPublishCommandsTask;
    }

    private void _configureLiferayRelengProperties(Project project) {
        String liferayRelengSupported;
        String liferayRelengPublic;
        String liferayRelengAppTitlePrefix;
        boolean privateModule = false;
        String projectPath = project.getPath();
        if (projectPath.startsWith(":dxp:") || projectPath.startsWith(":private:")) {
            privateModule = true;
        }
        if (Validator.isNull((String)(liferayRelengAppTitlePrefix = GradleUtil.getProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_APP_TITLE_PREFIX, (String)null)))) {
            liferayRelengAppTitlePrefix = privateModule ? "Liferay" : "Liferay CE";
            GradleUtil.setProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_APP_TITLE_PREFIX, (Object)liferayRelengAppTitlePrefix);
        }
        if (Validator.isNull((String)(liferayRelengPublic = GradleUtil.getProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_PUBLIC, (String)null)))) {
            liferayRelengPublic = String.valueOf(!privateModule);
            GradleUtil.setProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_PUBLIC, (Object)liferayRelengPublic);
        }
        if (Validator.isNull((String)(liferayRelengSupported = GradleUtil.getProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_SUPPORTED, (String)null)))) {
            liferayRelengSupported = String.valueOf(privateModule);
            GradleUtil.setProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_SUPPORTED, (Object)liferayRelengSupported);
        }
    }

    private void _configureTaskBuildChangeLog(BuildChangeLogTask buildChangeLogTask, File destinationDir) {
        String ticketIdPrefixes = GradleUtil.getProperty((ExtensionAware)buildChangeLogTask.getProject(), (String)"jira.project.keys", (String)null);
        if (Validator.isNotNull((String)ticketIdPrefixes)) {
            buildChangeLogTask.ticketIdPrefixes(ticketIdPrefixes.split(","));
        }
        buildChangeLogTask.setChangeLogFile((Object)new File(destinationDir, "liferay-releng.changelog"));
    }

    private void _configureTaskEnabledIfRelease(Task task) {
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Project project = task.getProject();
                return GradleUtil.hasStartParameterTask(project, task.getName()) || !GradlePluginsDefaultsUtil.isSnapshot(project);
            }
        });
    }

    private void _configureTaskPrintStaleArtifactForOSGi(Task task) {
        if (GradlePluginsDefaultsUtil.isTestProject(task.getProject())) {
            task.setEnabled(false);
        }
    }

    private void _configureTaskPrintStaleArtifactOnlyIf(Project project, Task printStaleArtifactTask, final WritePropertiesTask recordArtifactTask) {
        final boolean liferayThemeProject = GradleUtil.hasPlugin(project, LiferayThemeDefaultsPlugin.class);
        if (liferayThemeProject && GradlePluginsDefaultsUtil.hasNPMParentThemesDependencies(project)) {
            printStaleArtifactTask.dependsOn(new Object[]{"npmInstall"});
        }
        Spec<Task> onlyIfSpec = new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                File relengIgnoreDir;
                Pattern pattern;
                Matcher matcher;
                Project project = task.getProject();
                String ignoreProjectRegex = GradleUtil.getTaskPrefixedProperty((Task)task, (String)"ignore.project.regex");
                if (Validator.isNotNull((String)ignoreProjectRegex) && (matcher = (pattern = Pattern.compile(ignoreProjectRegex)).matcher(project.getName())).find()) {
                    return false;
                }
                File gitRepoDir = GradleUtil.getRootDir((Project)project, (String)".gitrepo");
                if (gitRepoDir != null) {
                    File file = new File(gitRepoDir, ".gitrepo");
                    try {
                        if (!FileUtil.contains(file, "mode = push")) {
                            return false;
                        }
                    }
                    catch (IOException ioException) {
                        throw new UncheckedIOException(ioException);
                    }
                }
                if ((relengIgnoreDir = GradleUtil.getRootDir((Project)project, (String)LiferayRelengPlugin.RELENG_IGNORE_FILE_NAME)) != null) {
                    return false;
                }
                String result = GitUtil.getGitResult(project, "ls-files", FileUtil.getAbsolutePath((File)project.getProjectDir()));
                if (Validator.isNull((String)result)) {
                    return false;
                }
                if (liferayThemeProject && LiferayRelengUtil.hasStaleParentTheme(project)) {
                    return true;
                }
                return LiferayRelengUtil.hasUnpublishedCommits(project, project.getProjectDir(), recordArtifactTask.getOutputFile());
            }
        };
        printStaleArtifactTask.onlyIf((Spec)onlyIfSpec);
    }

    private void _configureTaskProcessResources(Project project, final BuildChangeLogTask buildChangeLogTask) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"processResources");
        copy.from((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildChangeLogTask.getChangeLogFile();
            }
        }, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.into((Object)"META-INF");
            }
        });
    }

    private void _configureTaskUploadArchives(Project project, Task recordArtifactTask) {
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        uploadArchivesTask.dependsOn(new Object[]{recordArtifactTask});
        this._configureTaskEnabledIfRelease(recordArtifactTask);
    }

    private void _configureTaskWriteArtifactPublishCommandsForOSGi(WriteArtifactPublishCommandsTask writeArtifactPublishCommandsTask) {
        if (GradlePluginsDefaultsUtil.isTestProject(writeArtifactPublishCommandsTask.getProject())) {
            writeArtifactPublishCommandsTask.setEnabled(false);
        }
        writeArtifactPublishCommandsTask.setFirstPublishExcludedTaskName("updateFileVersions");
    }

    private void _configureTaskWriteArtifactPublishCommandsOnlyIf(Project project, WriteArtifactPublishCommandsTask writeArtifactPublishCommandsTask, final WritePropertiesTask recordArtifactTask) {
        final String force = GradleUtil.getTaskPrefixedProperty((Task)writeArtifactPublishCommandsTask, (String)"force");
        final boolean liferayThemeProject = GradleUtil.hasPlugin(project, LiferayThemeDefaultsPlugin.class);
        if (liferayThemeProject && GradlePluginsDefaultsUtil.hasNPMParentThemesDependencies(project)) {
            writeArtifactPublishCommandsTask.dependsOn(new Object[]{"npmInstall"});
        }
        Spec<Task> onlyIfSpec = new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                File relengIgnoreDir;
                Pattern pattern;
                Matcher matcher;
                Project project = task.getProject();
                String ignoreProjectRegex = GradleUtil.getTaskPrefixedProperty((Task)task, (String)"ignore.project.regex");
                if (Validator.isNotNull((String)ignoreProjectRegex) && (matcher = (pattern = Pattern.compile(ignoreProjectRegex)).matcher(project.getName())).find()) {
                    return false;
                }
                File gitRepoDir = GradleUtil.getRootDir((Project)project, (String)".gitrepo");
                if (gitRepoDir != null) {
                    File file = new File(gitRepoDir, ".gitrepo");
                    try {
                        if (!FileUtil.contains(file, "mode = push")) {
                            return false;
                        }
                    }
                    catch (IOException ioException) {
                        throw new UncheckedIOException(ioException);
                    }
                }
                if ((relengIgnoreDir = GradleUtil.getRootDir((Project)project, (String)LiferayRelengPlugin.RELENG_IGNORE_FILE_NAME)) != null) {
                    return false;
                }
                if (Boolean.parseBoolean(force)) {
                    return true;
                }
                String result = GitUtil.getGitResult(project, "ls-files", FileUtil.getAbsolutePath((File)project.getProjectDir()));
                if (Validator.isNull((String)result)) {
                    return false;
                }
                if (liferayThemeProject && LiferayRelengUtil.hasStaleParentTheme(project)) {
                    return true;
                }
                if (LiferayRelengUtil.hasUnpublishedCommits(project, project.getProjectDir(), recordArtifactTask.getOutputFile())) {
                    return !LiferayRelengUtil.hasUnpublishedDependencies(project);
                }
                return false;
            }
        };
        writeArtifactPublishCommandsTask.onlyIf((Spec)onlyIfSpec);
    }
}

