/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.LiferayYarnPlugin;
import com.liferay.gradle.plugins.SourceFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.LiferayAppDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.LiferayDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import java.io.File;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;

public class LiferayRootDefaultsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (FileUtil.exists((Project)project, (String)"app.bnd")) {
            GradleUtil.applyPlugin((Project)project, LiferayAppDefaultsPlugin.class);
        }
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        SourceFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        File portalRootDir = GradleUtil.getRootDir((Project)project.getRootProject(), (String)"portal-impl");
        GradlePluginsDefaultsUtil.configureRepositories(project, portalRootDir);
        for (Project subproject : project.getSubprojects()) {
            Map childProjects = subproject.getChildProjects();
            if (!childProjects.isEmpty()) continue;
            GradleUtil.applyPlugin((Project)subproject, LiferayDefaultsPlugin.class);
        }
        if (portalRootDir == null && this._hasYarnScriptFile(project)) {
            GradleUtil.applyPlugin((Project)project, LiferayYarnPlugin.class);
            for (Project subproject : project.getSubprojects()) {
                this._configureTasksNpmInstall(project, subproject);
            }
        }
    }

    private void _configureTaskNpmInstall(Project rootProject, NpmInstallTask npmInstallTask) {
        File scriptFile = npmInstallTask.getScriptFile();
        if (scriptFile == null) {
            return;
        }
        String fileName = scriptFile.getName();
        if (!fileName.startsWith("yarn-") || !fileName.endsWith(".js")) {
            return;
        }
        TaskContainer taskContainer = rootProject.getTasks();
        Task yarnInstallTask = (Task)taskContainer.findByName("yarnInstall");
        if (yarnInstallTask != null) {
            npmInstallTask.finalizedBy(new Object[]{yarnInstallTask});
        }
    }

    private void _configureTasksNpmInstall(final Project rootProject, Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                LiferayRootDefaultsPlugin.this._configureTaskNpmInstall(rootProject, npmInstallTask);
            }
        });
    }

    private boolean _hasYarnScriptFile(Project project) {
        File projectDir = project.getProjectDir();
        File[] files = FileUtil.getFiles(projectDir, "yarn-", ".js");
        return files != null && files.length > 0;
    }
}

