/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.baseline.BaselinePlugin;
import com.liferay.gradle.plugins.baseline.BaselineTask;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.extensions.BundleExtension;
import com.liferay.gradle.plugins.util.BndBuilderUtil;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;

public class BaselineDefaultsPlugin
extends BaseDefaultsPlugin<BaselinePlugin> {
    public static final Plugin<Project> INSTANCE = new BaselineDefaultsPlugin();

    protected void configureDefaults(Project project, BaselinePlugin baselinePlugin) {
        this._configureTasksBaseline(project);
    }

    protected Class<BaselinePlugin> getPluginClass() {
        return BaselinePlugin.class;
    }

    private BaselineDefaultsPlugin() {
    }

    private void _configureTaskBaseline(BaselineTask baselineTask) {
        baselineTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                BundleExtension bundleInstructions = BndBuilderUtil.getInstructions((Project)task.getProject());
                String exportPackage = GradleUtil.toString(bundleInstructions.get("Export-Package"));
                return !Validator.isNull((String)exportPackage);
            }
        });
    }

    private void _configureTasksBaseline(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BaselineTask.class, (Action)new Action<BaselineTask>(){

            public void execute(BaselineTask baselineTask) {
                BaselineDefaultsPlugin.this._configureTaskBaseline(baselineTask);
            }
        });
    }
}

