/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.node.tasks.PackageRunBuildTask;
import com.liferay.gradle.plugins.node.tasks.YarnInstallTask;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GUtil;

public class LiferayCIPatcherPlugin
implements Plugin<Project> {
    public static final String APPEND_HOTFIX_QUALIFIER_TASK_NAME = "appendHotfixQualifier";
    public static final Plugin<Project> INSTANCE = new LiferayCIPatcherPlugin();
    public static final String REMOVE_HOTFIX_QUALIFIER_TASK_NAME = "removeHotfixQualifier";
    private static final String _PATCHER_DIRS = System.getProperty("patcher.hotfix.dirs");
    private static final String _PATCHER_QUALIFIER = System.getProperty("patcher.hotfix.qualifier");

    public void apply(Project project) {
        Task appendHotfixQualifierTask = this._addTaskAppendHotfixQualifier(project);
        Task removeHotfixQualifierTask = this._addTaskRemoveHotfixQualifier(project);
        this._configureTasksPackageRunBuild(project);
        this._configureTasksNpmInstall(project);
        this._configureTasksYarnInstall(project, appendHotfixQualifierTask, removeHotfixQualifierTask);
    }

    private LiferayCIPatcherPlugin() {
    }

    private Task _addTaskAppendHotfixQualifier(Project project) {
        Task task = project.task(APPEND_HOTFIX_QUALIFIER_TASK_NAME);
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                for (String dirName : _PATCHER_DIRS.split(",")) {
                    Properties properties;
                    String version;
                    File bndBndFile = new File(new File(project.getProjectDir(), dirName), "bnd.bnd");
                    if (!bndBndFile.exists() || (version = (properties = GUtil.loadProperties((File)bndBndFile)).getProperty("Bundle-Version")) == null || version.indexOf(_PATCHER_QUALIFIER) != -1) continue;
                    this._updateBndBndFile(version, bndBndFile);
                    Logger logger = project.getLogger();
                    if (!logger.isLifecycleEnabled()) continue;
                    logger.lifecycle("Appended {}:{}", new Object[]{project.relativePath((Object)bndBndFile), _PATCHER_QUALIFIER});
                }
            }

            private void _updateBndBndFile(String version, File bndBndFile) {
                try {
                    String text = new String(Files.readAllBytes(bndBndFile.toPath()), StandardCharsets.UTF_8);
                    text = text.replaceAll("^Bundle-Version: .*$", "Bundle-Version: " + version + _PATCHER_QUALIFIER);
                    Files.write(bndBndFile.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException((Throwable)ioe);
                }
            }
        });
        return task;
    }

    private Task _addTaskRemoveHotfixQualifier(Project project) {
        Task task = project.task(REMOVE_HOTFIX_QUALIFIER_TASK_NAME);
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                for (String dirName : _PATCHER_DIRS.split(",")) {
                    Properties properties;
                    String version;
                    File bndBndFile = new File(new File(project.getProjectDir(), dirName), "bnd.bnd");
                    if (!bndBndFile.exists() || (version = (properties = GUtil.loadProperties((File)bndBndFile)).getProperty("Bundle-Version")) == null || version.indexOf(_PATCHER_QUALIFIER) == -1) continue;
                    this._updateBndBndFile(version, bndBndFile);
                    Logger logger = project.getLogger();
                    if (!logger.isLifecycleEnabled()) continue;
                    logger.lifecycle("Removed {}:{}", new Object[]{project.relativePath((Object)bndBndFile), _PATCHER_QUALIFIER});
                }
            }

            private void _updateBndBndFile(String version, File bndBndFile) {
                try {
                    String text = new String(Files.readAllBytes(bndBndFile.toPath()), StandardCharsets.UTF_8);
                    int x = version.length();
                    int y = _PATCHER_QUALIFIER.length();
                    text = text.replaceAll(version + "$", version.substring(0, x - y));
                    Files.write(bndBndFile.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException((Throwable)ioe);
                }
            }
        });
        return task;
    }

    private void _configureTaskNpmInstall(NpmInstallTask npmInstallTask) {
        npmInstallTask.setNodeModulesCacheDir(null);
    }

    private void _configureTaskPackageRunBuild(PackageRunBuildTask packageRunBuildTask) {
        TaskOutputsInternal taskOutputs = packageRunBuildTask.getOutputs();
        taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
    }

    private void _configureTasksNpmInstall(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                LiferayCIPatcherPlugin.this._configureTaskNpmInstall(npmInstallTask);
            }
        });
    }

    private void _configureTasksPackageRunBuild(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PackageRunBuildTask.class, (Action)new Action<PackageRunBuildTask>(){

            public void execute(PackageRunBuildTask packageRunBuildTask) {
                LiferayCIPatcherPlugin.this._configureTaskPackageRunBuild(packageRunBuildTask);
            }
        });
    }

    private void _configureTasksYarnInstall(Project project, final Task appendHotfixQualifierTask, final Task removeHotfixQualifierTask) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(YarnInstallTask.class, (Action)new Action<YarnInstallTask>(){

            public void execute(YarnInstallTask yarnInstallTask) {
                appendHotfixQualifierTask.mustRunAfter(new Object[]{yarnInstallTask});
                String taskName = yarnInstallTask.getName();
                if (taskName.equals("yarnInstall")) {
                    LiferayCIPatcherPlugin.this._configureTaskYarnInstall(appendHotfixQualifierTask, removeHotfixQualifierTask, yarnInstallTask);
                }
            }
        });
    }

    private void _configureTaskYarnInstall(Task appendHotfixQualifierTask, Task removeHotfixQualifierTask, YarnInstallTask yarnInstallTask) {
        if (Validator.isNotNull((String)_PATCHER_DIRS) && Validator.isNotNull((String)_PATCHER_QUALIFIER)) {
            yarnInstallTask.dependsOn(new Object[]{removeHotfixQualifierTask});
            yarnInstallTask.finalizedBy(new Object[]{appendHotfixQualifierTask});
        }
    }
}

